/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.ClientUtils;
import com.pushtechnology.diffusion.client.features.control.topics.SubscriptionControl;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionClosedException;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.client.topics.TopicSelection;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.command.commands.control.client.CountOrParserErrors;
import com.pushtechnology.diffusion.command.commands.control.client.SubscriptionByFilterRequest;
import com.pushtechnology.diffusion.command.commands.control.client.SubscriptionRequest;
import com.pushtechnology.diffusion.command.commands.control.client.UnsubscribeAllByFilterRequest;
import com.pushtechnology.diffusion.command.commands.control.client.UnsubscribeAllControlRequest;
import com.pushtechnology.diffusion.command.commands.control.topics.GetSelectorsRequest;
import com.pushtechnology.diffusion.command.commands.control.topics.GetSelectorsResult;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class SubscriptionControlImpl
extends AbstractFeature
implements SubscriptionControl {
    private final TopicSelectorParser topicSelectorParser;
    private final ServiceReference<SubscriptionRequest, Void> subscriber;
    private final ServiceReference<SubscriptionRequest, Void> unsubscriber;
    private final ServiceReference<SubscriptionByFilterRequest, CountOrParserErrors> filterSubscriber;
    private final ServiceReference<SubscriptionByFilterRequest, CountOrParserErrors> filterUnsubscriber;
    private final ServiceReference<GetSelectorsRequest, GetSelectorsResult> getSelectorsService;
    private final ServiceReference<UnsubscribeAllControlRequest, Void> unsubscribeAllControlService;
    private final ServiceReference<UnsubscribeAllByFilterRequest, CountOrParserErrors> unsubscribeAllByFilterService;

    public SubscriptionControlImpl(Session session, InternalSession internalSession, TopicSelectorParser topicSelectorParser) {
        super(session, internalSession);
        this.topicSelectorParser = topicSelectorParser;
        ServiceLocator services = internalSession.getServiceLocator();
        this.subscriber = services.obtainService(CommonServices.SUBSCRIBE_CONTROL);
        this.unsubscriber = services.obtainService(CommonServices.UNSUBSCRIBE_CONTROL);
        this.filterSubscriber = services.obtainService(CommonServices.FILTER_SUBSCRIBE);
        this.filterUnsubscriber = services.obtainService(CommonServices.FILTER_UNSUBSCRIBE);
        this.getSelectorsService = services.obtainService(CommonServices.GET_SELECTORS);
        this.unsubscribeAllControlService = services.obtainService(CommonServices.UNSUBSCRIBE_ALL_CONTROL);
        this.unsubscribeAllByFilterService = services.obtainService(CommonServices.UNSUBSCRIBE_ALL_BY_FILTER);
    }

    @Override
    public CompletableFuture<?> subscribe(SessionId client, String topics, String scope) throws SessionClosedException {
        return this.subscribe(client, this.topicSelectorParser.parse(Objects.requireNonNull(topics, "topics is null")), scope);
    }

    @Override
    public CompletableFuture<?> subscribe(SessionId sessionId, TopicSelector topics, String scope) throws SessionClosedException {
        return this.subscriber.sendCommand(SubscriptionControlImpl.createSubscriptionRequest(sessionId, topics, scope)).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<?> unsubscribe(SessionId client, String topics, String scope) throws SessionClosedException {
        return this.unsubscribe(client, this.topicSelectorParser.parse(Objects.requireNonNull(topics, "topics is null")), scope);
    }

    @Override
    public CompletableFuture<?> unsubscribe(SessionId sessionId, TopicSelector topics, String scope) throws SessionClosedException {
        return this.unsubscriber.sendCommand(SubscriptionControlImpl.createSubscriptionRequest(sessionId, topics, scope)).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> subscribeByFilter(String filter, String topics, String scope) {
        TopicSelector selector = this.topicSelectorParser.parse(Objects.requireNonNull(topics, "topics is null"));
        return this.subscribeByFilter(filter, selector, scope);
    }

    @Override
    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> subscribeByFilter(String filter, TopicSelector topics, String scope) {
        return this.filterSubscriber.sendCommand(SubscriptionControlImpl.createSubscriptionByFilterRequest(filter, topics, scope)).thenApply(response -> {
            int count = response.getCountChecked();
            return () -> count;
        });
    }

    @Override
    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> unsubscribeByFilter(String filter, String topics, String scope) {
        TopicSelector selector = this.topicSelectorParser.parse(Objects.requireNonNull(topics, "topics is null"));
        return this.unsubscribeByFilter(filter, selector, scope);
    }

    @Override
    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> unsubscribeByFilter(String filter, TopicSelector topics, String scope) {
        return this.filterUnsubscriber.sendCommand(SubscriptionControlImpl.createSubscriptionByFilterRequest(filter, topics, scope)).thenApply(response -> {
            int count = response.getCountChecked();
            return () -> count;
        });
    }

    @Override
    public CompletableFuture<?> unsubscribeAllScopes(SessionId sessionId, String topics) {
        return this.unsubscribeAllScopes(sessionId, this.topicSelectorParser.parse(Objects.requireNonNull(topics, "topics is null")));
    }

    @Override
    public CompletableFuture<?> unsubscribeAllScopes(SessionId sessionId, TopicSelector topics) {
        return this.unsubscribeAllControlService.sendCommand(new UnsubscribeAllControlRequest(Objects.requireNonNull(topics, "topics is null").getExpression(), (InternalSessionId)Objects.requireNonNull(sessionId, "sessionId is null"))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> unsubscribeAllScopesByFilter(String filter, String topics) {
        return this.unsubscribeAllScopesByFilter(filter, this.topicSelectorParser.parse(Objects.requireNonNull(topics, "topics is null")));
    }

    @Override
    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> unsubscribeAllScopesByFilter(String filter, TopicSelector topics) {
        return this.unsubscribeAllByFilterService.sendCommand(new UnsubscribeAllByFilterRequest(Objects.requireNonNull(topics, "topics is null").getExpression(), Objects.requireNonNull(filter, "filter is null"))).thenApply(response -> {
            int count = response.getCountChecked();
            return () -> count;
        });
    }

    @Override
    public CompletableFuture<Map<String, List<TopicSelection>>> getTopicSelections(SessionId sessionId) {
        return this.getSelectorsService.sendCommand(new GetSelectorsRequest((InternalSessionId)Objects.requireNonNull(sessionId, "sessionId is null"))).thenApply(result -> ClientUtils.convertSelectorMap(result.getScopeMap(), this.topicSelectorParser));
    }

    private static SubscriptionRequest createSubscriptionRequest(SessionId sessionId, TopicSelector topics, String scope) {
        return new SubscriptionRequest((InternalSessionId)Objects.requireNonNull(sessionId, "sessionId is null"), Objects.requireNonNull(topics, "topics is null").getExpression(), ClientUtils.validateSelectionScope(scope));
    }

    private static SubscriptionByFilterRequest createSubscriptionByFilterRequest(String filter, TopicSelector topics, String scope) {
        return new SubscriptionByFilterRequest(Objects.requireNonNull(filter, "filter is null"), Objects.requireNonNull(topics, "topics is null").getExpression(), ClientUtils.validateSelectionScope(scope));
    }
}

