/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.impl.InternalClientControl;
import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQueryResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
final class SessionFetchResultImpl
implements InternalClientControl.SessionFetchResult {
    private final List<InternalClientControl.SessionFetchResult.SessionResult> theSessions;
    private final int theTotalSelected;

    SessionFetchResultImpl(SessionFetchQueryResult result, boolean requiresStartTime) {
        this.theTotalSelected = result.totalSelectedChecked();
        ArrayList sessions = new ArrayList();
        result.sessions().forEach(session -> sessions.add(new SessionResultImpl((SessionFetchQueryResult.SessionInfo)session, requiresStartTime)));
        this.theSessions = Collections.unmodifiableList(sessions);
    }

    @Override
    public List<InternalClientControl.SessionFetchResult.SessionResult> sessions() {
        return this.theSessions;
    }

    @Override
    public boolean hasMore() {
        return this.theTotalSelected > this.theSessions.size();
    }

    @Override
    public int size() {
        return this.sessions().size();
    }

    @Override
    public boolean isEmpty() {
        return this.theSessions.isEmpty();
    }

    @Override
    public int totalSelected() {
        return this.theTotalSelected;
    }

    public int hashCode() {
        return Objects.hash(this.theTotalSelected, this.theSessions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionFetchResultImpl other = (SessionFetchResultImpl)obj;
        return this.theTotalSelected == other.theTotalSelected && this.theSessions.equals(other.theSessions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SessionFetchResult [sessions=").append(this.theSessions).append(", total selected=").append(this.theTotalSelected).append(']');
        return sb.toString();
    }

    @Immutable
    static final class SessionResultImpl
    implements InternalClientControl.SessionFetchResult.SessionResult {
        private final Map<String, String> theProperties;

        SessionResultImpl(SessionFetchQueryResult.SessionInfo session, boolean includeStartTime) {
            Map<String, String> newProperties;
            if (includeStartTime) {
                long startTime = session.getStartTime();
                newProperties = new HashMap<String, String>(session.getProperties());
                newProperties.put("$StartTime", Long.toString(startTime));
            } else {
                newProperties = session.getProperties();
            }
            this.theProperties = Collections.unmodifiableMap(newProperties);
        }

        @Override
        public Map<String, String> properties() {
            return this.theProperties;
        }

        public int hashCode() {
            return this.theProperties.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionResultImpl other = (SessionResultImpl)obj;
            return this.theProperties.equals(other.theProperties);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SessionResult [Properties=").append(this.theProperties).append(']');
            return sb.toString();
        }
    }
}

