/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.api.internal.connection.DiffusionURI;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class RemoteServerBuilderImpl<B>
implements RemoteServers.RemoteServer.RemoteServerBuilder<B> {
    private final RemoteServers.RemoteServer.Type theType;

    RemoteServerBuilderImpl(RemoteServers.RemoteServer.Type type) {
        this.theType = type;
    }

    protected final RemoteServers.RemoteServer.Type getType() {
        return this.theType;
    }

    public final String toString() {
        return String.valueOf((Object)this.theType) + " Builder";
    }

    static String validateName(String name) {
        String trimmedName = Objects.requireNonNull(name, "name is null").trim();
        if (trimmedName.length() == 0) {
            throw new IllegalArgumentException("Non whitespace name must be supplied");
        }
        return trimmedName;
    }

    String validateUrl(String url) {
        String trimmedUrl = Objects.requireNonNull(url, "url is null").trim();
        DiffusionURI uri = DiffusionURI.parse(trimmedUrl);
        if (uri.getTransport() != SessionAttributes.Transport.WEBSOCKET) {
            throw new IllegalArgumentException("Transport for url " + url + " must be ws");
        }
        if (this.theType == RemoteServers.RemoteServer.Type.PRIMARY_INITIATOR && uri.isSecure()) {
            throw new IllegalArgumentException("Invalid url " + url + " - secure connection not supported for primary initiator connections");
        }
        return trimmedUrl;
    }
}

