/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.topics.TopicSelectors;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsImpl;
import com.pushtechnology.diffusion.servers.RemoteServerDefinitionImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class DeprecatedRemoteServerBuilder
implements RemoteServers.RemoteServer.Builder {
    private final TopicSelectors theTopicSelectors;
    private String thePrincipal = "";
    private Credentials theCredentials = CredentialsImpl.NO_CREDENTIALS;
    private Map<RemoteServers.RemoteServer.ConnectionOption, String> theConnectionOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>();
    private String theMissingTopicNotificationFilter = null;

    public DeprecatedRemoteServerBuilder(TopicSelectors topicSelectors) {
        this.theTopicSelectors = topicSelectors;
    }

    @Override
    public RemoteServers.RemoteServer.Builder principal(String principal) {
        this.thePrincipal = Objects.requireNonNull(principal, "principal is null");
        return this;
    }

    @Override
    public RemoteServers.RemoteServer.Builder credentials(Credentials credentials) {
        this.theCredentials = Objects.requireNonNull(credentials, "credentials is null");
        return this;
    }

    @Override
    public RemoteServers.RemoteServer.Builder connectionOptions(Map<RemoteServers.RemoteServer.ConnectionOption, String> connectionOptions) {
        this.theConnectionOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>(Objects.requireNonNull(connectionOptions, "connectionOptions is null"));
        return this;
    }

    @Override
    public RemoteServers.RemoteServer.Builder connectionOption(RemoteServers.RemoteServer.ConnectionOption connectionOption, String value) {
        if (value == null) {
            this.theConnectionOptions.remove((Object)Objects.requireNonNull(connectionOption, "connectionOption is null"));
        } else {
            this.theConnectionOptions.put(Objects.requireNonNull(connectionOption, "connectionOption is null"), Objects.requireNonNull(value, "value is null"));
        }
        return this;
    }

    @Override
    public RemoteServers.RemoteServer.Builder missingTopicNotificationFilter(String filter) {
        if (filter != null) {
            try {
                this.theTopicSelectors.parse(filter);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("filter is invalid", ex);
            }
        }
        this.theMissingTopicNotificationFilter = filter;
        return this;
    }

    @Override
    public RemoteServers.RemoteServer.Builder reset() {
        this.thePrincipal = "";
        this.theCredentials = CredentialsImpl.NO_CREDENTIALS;
        this.theConnectionOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>();
        this.theMissingTopicNotificationFilter = null;
        return this;
    }

    @Override
    public RemoteServers.RemoteServer create(String name, String url) {
        String trimmedName = Objects.requireNonNull(name, "name is null").trim();
        if (trimmedName.length() == 0) {
            throw new IllegalArgumentException("Non whitespace name must be supplied");
        }
        String trimmedUrl = Objects.requireNonNull(url, "url is null").trim();
        if (trimmedUrl.length() == 0) {
            throw new IllegalArgumentException("Non whitespace url must be supplied");
        }
        return RemoteServerDefinitionImpl.createSecondaryDefinition(RemoteServers.RemoteServer.Type.SECONDARY_INITIATOR, trimmedName, trimmedUrl, this.thePrincipal, this.theConnectionOptions, this.theMissingTopicNotificationFilter, this.theCredentials);
    }
}

