/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.clients;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.features.control.clients.MessageQueuePolicy;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionId;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientControl
extends Feature {
    public CompletableFuture<Registration> addSessionEventListener(SessionEventStream var1, SessionEventParameters var2);

    @Deprecated
    public CompletableFuture<Registration> setSessionPropertiesListener(SessionPropertiesStream var1, String ... var2);

    public CompletableFuture<Map<String, String>> getSessionProperties(SessionId var1, Collection<String> var2);

    public CompletableFuture<Map<String, String>> setSessionProperties(SessionId var1, Map<String, String> var2);

    public CompletableFuture<SessionFilterOperationResult> setSessionProperties(String var1, Map<String, String> var2);

    public CompletableFuture<Registration> setQueueEventHandler(QueueEventStream var1);

    public CompletableFuture<?> close(SessionId var1);

    public CompletableFuture<SessionFilterOperationResult> close(String var1);

    public CompletableFuture<?> setConflated(SessionId var1, boolean var2);

    public CompletableFuture<SessionFilterOperationResult> setConflated(String var1, boolean var2);

    public CompletableFuture<?> changeRoles(SessionId var1, Set<String> var2, Set<String> var3) throws IllegalArgumentException;

    public CompletableFuture<Integer> changeRoles(String var1, Set<String> var2, Set<String> var3) throws IllegalArgumentException;

    public CompletableFuture<SessionLockDetails> getSessionLock(String var1);

    public CompletableFuture<Map<String, SessionLockDetails>> getSessionLocks();

    public static interface SessionLockDetails {
        public String serverName();

        public SessionId sessionId();

        public long sequence();
    }

    public static interface SessionFilterOperationResult {
        public int selected();
    }

    public static enum CloseReason {
        CONNECTION_LOST,
        IO_EXCEPTION,
        CLIENT_UNRESPONSIVE,
        MESSAGE_QUEUE_LIMIT_REACHED,
        CLOSED_BY_CLIENT,
        MESSAGE_TOO_LARGE,
        INTERNAL_ERROR,
        INVALID_INBOUND_MESSAGE,
        ABORTED,
        LOST_MESSAGES,
        CLOSED_BY_CONTROLLER,
        FAILED_OVER,
        EXPIRED,
        REVOKED,
        SESSION_TAKEN_OVER;

    }

    public static interface SessionEventParameters {
        public static final SessionEventParameters DEFAULT = Diffusion.newSessionEventParametersBuilder().build();

        public String filter();

        public Set<String> properties();

        public Instant after();

        public static interface Builder {
            public Builder filter(String var1);

            public Builder properties(String ... var1);

            public Builder after(Instant var1);

            public SessionEventParameters build();
        }
    }

    public static interface SessionEventStream
    extends Stream {
        public void onSessionEvent(Event var1);

        public static class Default
        extends Stream.Default
        implements SessionEventStream {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onSessionEvent(Event event) {
                LOG.debug(event.toString());
            }
        }

        public static interface Event {
            public SessionId sessionId();

            public Type type();

            public State state();

            public boolean isOpenEvent();

            public Map<String, String> properties();

            public Map<String, String> changedProperties();

            public CloseReason closeReason();

            public static enum State {
                ACTIVE,
                DISCONNECTED,
                RECONNECTED,
                FAILED_OVER,
                CLOSED;

            }

            public static enum Type {
                STATE,
                PROPERTIES;

            }
        }
    }

    @Deprecated
    public static interface SessionPropertiesStream
    extends Stream {
        public void onSessionOpen(SessionId var1, Map<String, String> var2);

        public void onSessionEvent(SessionId var1, EventType var2, Map<String, String> var3, Map<String, String> var4);

        public void onSessionClose(SessionId var1, Map<String, String> var2, CloseReason var3);

        public static class Default
        extends Stream.Default
        implements SessionPropertiesStream {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onSessionOpen(SessionId sessionId, Map<String, String> properties) {
                LOG.debug("{} - Client session {} opened : {}", this, sessionId, properties);
            }

            @Override
            public void onSessionEvent(SessionId sessionId, EventType eventType, Map<String, String> properties, Map<String, String> previousValues) {
                LOG.debug("{} - Client session {} event : {}, Properties={}, Previous Values={}", new Object[]{this, sessionId, eventType, properties, previousValues});
            }

            @Override
            public void onSessionClose(SessionId sessionId, Map<String, String> properties, CloseReason closeReason) {
                LOG.debug("{} - Client session {} closed - {} : {}", new Object[]{this, sessionId, closeReason, properties});
            }
        }

        public static enum EventType {
            UPDATED,
            RECONNECTED,
            FAILED_OVER,
            DISCONNECTED;

        }
    }

    public static interface QueueEventStream
    extends Stream {
        public void onUpperThresholdCrossed(SessionId var1, MessageQueuePolicy var2);

        public void onLowerThresholdCrossed(SessionId var1, MessageQueuePolicy var2);

        public static class Default
        extends Stream.Default
        implements QueueEventStream {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onUpperThresholdCrossed(SessionId sessionId, MessageQueuePolicy policy) {
                LOG.debug("{} - Session {} with policy {} : Upper queue threshold crossed", this, sessionId, policy);
            }

            @Override
            public void onLowerThresholdCrossed(SessionId sessionId, MessageQueuePolicy policy) {
                LOG.debug("{} - Session {} with policy {} : Lower queue threshold crossed", this, sessionId, policy);
            }
        }
    }
}

