/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.callbacks;

public final class ErrorReason {
    public static final ErrorReason COMMUNICATION_FAILURE = new ErrorReason(100, "Communication with server failed");
    public static final ErrorReason SESSION_CLOSED = new ErrorReason(101, "Session is closed");
    public static final ErrorReason REQUEST_TIME_OUT = new ErrorReason(102, "Request time out");
    public static final ErrorReason ACCESS_DENIED = new ErrorReason(103, "Access denied");
    public static final ErrorReason UNSUPPORTED = new ErrorReason(104, "Unsupported service");
    public static final ErrorReason CALLBACK_EXCEPTION = new ErrorReason(105, "An application callback threw an exception. Check logs for more information.");
    public static final ErrorReason INVALID_DATA = new ErrorReason(106, "Invalid data.");
    public static final ErrorReason NO_SUCH_SESSION = new ErrorReason(107, "No session was found");
    public static final ErrorReason INCOMPATIBLE_DATATYPE = new ErrorReason(108, "Datatype is incompatible");
    public static final ErrorReason UNHANDLED_MESSAGE = new ErrorReason(109, "A message was not handled");
    public static final ErrorReason CLUSTER_REPARTITION = new ErrorReason(110, "The cluster was repartitioning and the request could not be routed.");
    public static final ErrorReason INCOMPATIBLE_STATE = new ErrorReason(111, "Topic operation not performed because it is managed by a component that prohibits external updates");
    public static final ErrorReason CLUSTER_ROUTING = new ErrorReason(112, "The cluster operation could not be routed.");
    public static final ErrorReason TOPIC_TREE_REGISTRATION_CONFLICT = new ErrorReason(200, "A conflicting registration exists on the same branch of the topic tree");
    public static final ErrorReason HANDLER_CONFLICT = new ErrorReason(201, "Conflict with existing handler");
    public static final ErrorReason INVALID_PATH = new ErrorReason(202, "Invalid path");
    private final int reasonCode;
    private final String description;

    public ErrorReason(int reasonCode, String description) {
        this.reasonCode = reasonCode;
        this.description = description;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.getReasonCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ErrorReason other = (ErrorReason)o;
        return other.getReasonCode() == this.getReasonCode();
    }

    public String toString() {
        return this.reasonCode + ": " + this.description;
    }
}

