/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.cache;

import com.pushtechnology.diffusion.cache.Cache;
import com.pushtechnology.diffusion.util.concurrent.scheduled.Periodic;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class WeakValueCache<K, V>
implements Cache<K, V>,
Periodic {
    private final ConcurrentMap<K, KeyReference<K, V>> cache = new ConcurrentHashMap<K, KeyReference<K, V>>(1000, 0.75f, 4);
    private final ReferenceQueue<V> deadQueue = new ReferenceQueue();
    private final long cleanPeriodMillis;
    private final AtomicInteger putCount = new AtomicInteger();
    private volatile long flushOnPutThreshold = 1024L;

    public WeakValueCache(long cleanPeriodMillis) {
        this.cleanPeriodMillis = cleanPeriodMillis;
    }

    @Override
    public Pair<Long, Runnable> getPeriodicTask() {
        return Pair.of(this.cleanPeriodMillis, this::clean);
    }

    private void clean() {
        Reference<V> reference;
        while ((reference = this.deadQueue.poll()) != null) {
            KeyReference keyReference = (KeyReference)reference;
            this.cache.remove(keyReference.key);
        }
        return;
    }

    int size() {
        return this.cache.size();
    }

    @Override
    public V get(K key) {
        WeakReference reference = (WeakReference)this.cache.get(key);
        if (reference != null) {
            return (V)reference.get();
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, new KeyReference<K, V>(key, Objects.requireNonNull(value, "Null values may not be cached"), this.deadQueue));
        this.adjustThreshold();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        V value = mappingFunction.apply(key);
        this.put(key, value);
        return value;
    }

    private void adjustThreshold() {
        int oldSize;
        if ((this.putCount.incrementAndGet() & 0x3FF) == 0 && (long)(oldSize = this.size()) > this.flushOnPutThreshold) {
            this.clean();
            int newSize = this.size();
            if (newSize > oldSize >> 1) {
                this.flushOnPutThreshold <<= 1;
            }
        }
    }

    private static class KeyReference<K, V>
    extends WeakReference<V> {
        private final K key;

        KeyReference(K key, V value, ReferenceQueue<V> referenceQueue) {
            super(value, referenceQueue);
            this.key = key;
        }
    }
}

