/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.api.internal.connection;

import com.pushtechnology.diffusion.api.internal.connection.DiffusionURI;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetailsImpl;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class ServerDetailsFactory {
    private ServerDetailsFactory() {
    }

    public static ServerDetails create(String url) {
        DiffusionURI uri = DiffusionURI.parse(url);
        return new ServerDetailsImpl(uri.getTransport(), uri.getHost(), uri.getPort(), uri.isSecure(), uri.getPath());
    }

    public static List<ServerDetails> create(SessionAttributes sessionAttributes) {
        ArrayList<ServerDetails> detailsList = new ArrayList<ServerDetails>();
        for (SessionAttributes.Transport transport : sessionAttributes.getRequestedTransports()) {
            ServerDetailsImpl details = new ServerDetailsImpl(transport, sessionAttributes.getServerHost(), sessionAttributes.getServerPort(), sessionAttributes.isTransportSecure(), sessionAttributes.getRequestPath());
            details.setConnectionTimeout(sessionAttributes.getConnectionTimeout());
            details.setWriteTimeout(sessionAttributes.getWriteTimeout());
            details.setInputBufferSize(sessionAttributes.getInputBufferSize());
            details.setOutputBufferSize(sessionAttributes.getOutputBufferSize());
            details.setLocalSocketAddress(sessionAttributes.getLocalSocketAddress());
            details.setSSLContext(sessionAttributes.getSslContext());
            detailsList.add(details);
        }
        return detailsList;
    }

    public static String getURI(String serverHost, int targetServerPort, SessionAttributes.Transport transport, boolean isSecure, String path) {
        String scheme = ServerDetailsFactory.getScheme(transport, isSecure);
        if (isSecure && targetServerPort == 443 || !isSecure && targetServerPort == 80) {
            return scheme + serverHost + path;
        }
        return scheme + serverHost + ":" + targetServerPort + path;
    }

    private static String getScheme(SessionAttributes.Transport protocol, boolean isSecure) {
        switch (protocol) {
            case WEBSOCKET: {
                return isSecure ? "wss://" : "ws://";
            }
            case HTTP_POLLING: {
                return isSecure ? "xhrs://" : "xhr://";
            }
        }
        throw new IllegalArgumentException("The protocol " + String.valueOf((Object)protocol) + " is not supported");
    }
}

