/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.api.internal.connection;

import com.pushtechnology.diffusion.client.session.SessionAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
public final class DiffusionURI {
    private final SessionAttributes.Transport transport;
    private final String host;
    private final int port;
    private final boolean isSecure;
    private final String path;

    public static DiffusionURI parse(String url) {
        URI uri = DiffusionURI.canonicaliseConnectionURI(url);
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("No scheme: " + String.valueOf(uri));
        }
        return new DiffusionURI(scheme, uri);
    }

    private DiffusionURI(String scheme, URI uri) {
        this.host = uri.getHost();
        switch (scheme) {
            case "ws": {
                this.transport = SessionAttributes.Transport.WEBSOCKET;
                this.isSecure = false;
                this.port = DiffusionURI.portOrHTTPDefault(uri);
                this.path = uri.getPath();
                break;
            }
            case "wss": {
                this.transport = SessionAttributes.Transport.WEBSOCKET;
                this.isSecure = true;
                this.port = DiffusionURI.portOrHTTPSDefault(uri);
                this.path = uri.getPath();
                break;
            }
            case "xhr": {
                this.transport = SessionAttributes.Transport.HTTP_POLLING;
                this.isSecure = false;
                this.port = DiffusionURI.portOrHTTPDefault(uri);
                this.path = uri.getPath();
                break;
            }
            case "xhrs": {
                this.transport = SessionAttributes.Transport.HTTP_POLLING;
                this.isSecure = true;
                this.port = DiffusionURI.portOrHTTPSDefault(uri);
                this.path = uri.getPath();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scheme: " + scheme);
            }
        }
    }

    private static int portOrHTTPDefault(URI uri) {
        int configured = uri.getPort();
        return configured != -1 ? configured : 80;
    }

    private static int portOrHTTPSDefault(URI uri) {
        int configured = uri.getPort();
        return configured != -1 ? configured : 443;
    }

    public SessionAttributes.Transport getTransport() {
        return this.transport;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getPath() {
        return this.path;
    }

    private static URI canonicaliseConnectionURI(String url) {
        try {
            URI uri = new URI(url);
            URI canonicalURI = uri.getHost() == null ? new URI(uri.getScheme(), "//" + uri.getSchemeSpecificPart(), null) : new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
            String uriPath = canonicalURI.getPath();
            if (!uriPath.contains("/diffusion")) {
                return URI.create(String.valueOf(new URI(canonicalURI.getScheme(), null, canonicalURI.getHost(), canonicalURI.getPort(), null, null, null)) + "/diffusion");
            }
            return canonicalURI;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("url " + url + " is invalid", e);
        }
    }
}

