# Diffusion .NET Client Library Changes

## Version 6.12.0

Bugs fixed:

* Split-path pattern and full-path pattern topic selectors allow the use of regular expression quotes (\Q,\E). In previous releases, the quotes were handled incorrectly: any backslash (\) character between the quotes was interpreted as the end of the literal section. This bug has been fixed in this release. Now everything between \Q and \E is correctly treated as literal characters.
* The Dotnet SDK client did not store messages sent to the client during the reconnection phase. Therefore on successful reconnection these messages were lost. This bug has been fixed in this release.

Highlights:

* There is a new API in the IClientControl feature which enables control clients to query session locks. There is a GetSessionLocksAsync method, which returns details of all current session locks, as well as a GetSessionLockAsync method to query a specific named session lock.
* There is a new Metrics Notifications feature which allows metrics alerts to be notified to topics when certain criteria are satisfied. For example, an alert could be set up which will write to a topic when the memory utilisation exceeds a specified threshold.
* There is a new feature, known as 'Topic Selection Scopes'. It is possible to specify a named scope when subscribing, such that a later unsubscription specifying that scope has no effect on other subscriptions that named a different scope. This allows subscriptions to be localised to the components that need them.
* There is a new session property called "$ExpiryTime" which can be set by an authenticator and if set will cause the session to be automatically closed by the server when the specified time is reached. 
* The client session can reauthenticate before it expires using the new 'reauthenticate' method provided in the ISecurity feature. 
* The client session itself now has a new "GetSessionPropertiesAsync" method, which allows it to get the values of its own fixed session properties, and thus determine when it is due to expire.
* The IAuthenticationControl feature has a new "RevokeAuthenticationAsync" method, which allows a session with sufficient privilege to revoke the authentication of a client session, causing its immediate closure.
* SetQueueEventHandlerAsync in IClientControl has been added. It is the asynchronous method for SetQueueEventHandler using IQueueEventStream and which returns a Task.
* OpenAsync in ISessionFactory has been added. It is the asynchronous method for Open which returns a Task.
* A topic selector can now be used in ISubscriptionControl API for topic paths.
* The Dotnet SDK client can now specify a custom URL path to connect to Diffusion through use of the new parameterless ISessionFactory Open and OpenAsync API in conjunction with the new ISessionFactory attributes: ServerHost, ServerPort, SecureTransport and RequestPath.
* The SELECT_TOPIC path permission is required for all paths that a topic selector may match, not just the path prefix.

Added:

* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IAuthenticationControl.RevokeAuthenticationAsync(ISessionId)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IAuthenticationControl.RevokeAuthenticationAsync(ISessionId,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.GetSessionLockAsync(string)->Task<ISessionLockDetails>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.GetSessionLockAsync(string,CancellationToken)->Task<ISessionLockDetails>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.GetSessionLocksAsync()->Task<IReadOnlyDictionary<string,ISessionLockDetails>>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.GetSessionLocksAsync(CancellationToken)->Task<IReadOnlyDictionary<string,ISessionLockDetails>>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.ISessionLockDetails.Sequence{get;}->long`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.ISessionLockDetails.ServerName{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.ISessionLockDetails.SessionId{get;}->ISessionId`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.ISessionLockDetails`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.SetQueueEventHandlerAsync(IQueueEventStream)->Task<IRegistration>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.SetQueueEventHandlerAsync(IQueueEventStream,CancellationToken)->Task<IRegistration>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IQueueEventStream.OnLowerThresholdCrossed(ISessionId,IMessageQueuePolicy)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IQueueEventStream.OnUpperThresholdCrossed(ISessionId,IMessageQueuePolicy)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IQueueEventStream`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.QueueEventStreamDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.GetTopicSelectionsAsync(ISessionId)->Task<IDictionary<string,List<ITopicSelection>>>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.GetTopicSelectionsAsync(ISessionId,CancellationToken)->Task<IDictionary<string,List<ITopicSelection>>>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.ITopicSelection.Selector{get;}->ITopicSelector`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.ITopicSelection.Type{get;}->TopicSelectionType`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.ITopicSelection`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeAsync(ISessionId,ITopicSelector)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeAsync(ISessionId,ITopicSelector,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeAsync(ISessionId,ITopicSelector,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeAsync(ISessionId,ITopicSelector,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeAsync(ISessionId,string,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeAsync(ISessionId,string,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilterAsync(string,ITopicSelector)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilterAsync(string,ITopicSelector,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilterAsync(string,ITopicSelector,string)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilterAsync(string,ITopicSelector,string,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilterAsync(string,string,string)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilterAsync(string,string,string,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.TopicSelectionType.DESELECT`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.TopicSelectionType.SELECT`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.TopicSelectionType`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesAsync(ISessionId,ITopicSelector)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesAsync(ISessionId,ITopicSelector,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesAsync(ISessionId,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesAsync(ISessionId,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesByFilterAsync(string,ITopicSelector)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesByFilterAsync(string,ITopicSelector,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesByFilterAsync(string,string)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAllScopesByFilterAsync(string,string,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAsync(ISessionId,ITopicSelector)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAsync(ISessionId,ITopicSelector,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAsync(ISessionId,ITopicSelector,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAsync(ISessionId,ITopicSelector,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAsync(ISessionId,string,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeAsync(ISessionId,string,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilterAsync(string,ITopicSelector)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilterAsync(string,ITopicSelector,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilterAsync(string,ITopicSelector,string)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilterAsync(string,ITopicSelector,string,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilterAsync(string,string,string)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilterAsync(string,string,string,CancellationToken)->Task<ISubscriptionByFilterResult>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.SubscribeAsync(ITopicSelector,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.SubscribeAsync(ITopicSelector,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.SubscribeAsync(string,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.SubscribeAsync(string,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAllScopesAsync(ITopicSelector)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAllScopesAsync(ITopicSelector,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAllScopesAsync(string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAllScopesAsync(string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAsync(ITopicSelector,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAsync(ITopicSelector,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAsync(string,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.ITopics.UnsubscribeAsync(string,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricAlert.Name{get;set;}->string`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricAlert.Principal{get;set;}->string`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricAlert.Specification{get;set;}->string`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricAlert`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics.ListMetricAlertsAsync()->Task<List<IMetricAlert>>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics.ListMetricAlertsAsync(CancellationToken)->Task<List<IMetricAlert>>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics.RemoveMetricAlertAsync(string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics.RemoveMetricAlertAsync(string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics.SetMetricAlertAsync(string,string)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics.SetMetricAlertAsync(string,string,CancellationToken)->Task<object>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetrics`
* `PushTechnology.ClientInterface.Client.Session.CloseReason.EXPIRED`
* `PushTechnology.ClientInterface.Client.Session.CloseReason.REVOKED`
* `PushTechnology.ClientInterface.Client.Session.ISession.GetSessionPropertiesAsync()->Task<IReadOnlyDictionary<string,string>>`
* `PushTechnology.ClientInterface.Client.Session.ISession.GetSessionPropertiesAsync(CancellationToken)->Task<IReadOnlyDictionary<string,string>>`
* `PushTechnology.ClientInterface.Client.Session.ISessionAttributes.DEFAULT_REQUEST_PATH`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.Open()->ISession`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.OpenAsync()->Task<ISession>`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.OpenAsync(CancellationToken)->Task<ISession>`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.OpenAsync(string)->Task<ISession>`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.OpenAsync(string,CancellationToken )->Task<ISession>`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.RequestPath(string)->ISessionFactory`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.SecureTransport(bool)->ISessionFactory`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.ServerHost(string)->ISessionFactory`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.ServerPort(int)->ISessionFactory`
* `PushTechnology.ClientInterface.Client.Session.SessionProperty.EXPIRY_TIME`

Deprecated:

* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.SetQueueEventHandler(IQueueEventHandler)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IQueueEventHandler.OnLowerThresholdCrossed(ISessionId,IMessageQueuePolicy)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IQueueEventHandler.OnUpperThresholdCrossed(ISessionId,IMessageQueuePolicy)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IQueueEventHandler`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesListener.OnSessionClose(ISessionId,IDictionary<string,string>,CloseReason)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesListener.OnSessionEvent(ISessionId,SessionPropertiesListenerEventType?,IDictionary<string,string>,IDictionary<string,string>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesListener.OnSessionOpen(ISessionId,IDictionary<string,string>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesListener`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.Open(string,ISessionOpenCallback)->void`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.Open<TContext>(string,TContext,ISessionOpenContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Session.ISessionOpenCallback.OnOpened(ISession)->void`
* `PushTechnology.ClientInterface.Client.Session.ISessionOpenCallback`
* `PushTechnology.ClientInterface.Client.Session.ISessionOpenContextCallback<in TContext>.OnOpened(TContext,ISession)->void`

Removed:

* `PushTechnology.ClientInterface.Client.Callbacks.DefaultContextStream<TContext>`
* `PushTechnology.ClientInterface.Client.Callbacks.IContextStream<in TContext>.OnClose(TContext)->void`
* `PushTechnology.ClientInterface.Client.Callbacks.IContextStream<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.CallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.ChangePrincipalCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.ChangePrincipalContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.ContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientCallback.OnComplete()->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientContextCallback<in TContext>.OnComplete(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.Close(ISessionId,IClientCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.Close<TC>(ISessionId,TC,IClientContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.GetSessionProperties(ISessionId,List<string>,ISessionPropertiesCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.GetSessionProperties<TC>(ISessionId,List<string>,TC,ISessionPropertiesContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.SetConflated(ISessionId,bool,IClientCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.SetConflated<TC>(ISessionId,bool,TC,IClientContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IConfigurationCallback.OnReply(ISystemAuthenticationConfiguration)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IConfigurationCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IConfigurationContextCallback<in TContext>.OnReply(TContext,ISystemAuthenticationConfiguration)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IConfigurationContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServers.CreateRemoteServerAsync(string,string,string,ICredentials)->Task<IRemoteServer>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServers.CreateRemoteServerAsync(string,string,string,ICredentials,CancellationToken )->Task<IRemoteServer>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServers.CreateRemoteServerAsync(string,string,string,ICredentials,Dictionary<RemoteServerConnectionOption,string>)->Task<IRemoteServer>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServers.CreateRemoteServerAsync(string,string,string,ICredentials,Dictionary<RemoteServerConnectionOption,string>,CancellationToken )->Task<IRemoteServer>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesContextCallback<TC>.OnReply(TC,ISessionId,Dictionary<string,string>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesContextCallback<TC>.OnUnknownSession(TC,ISessionId)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionPropertiesContextCallback<TC>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISystemAuthenticationControl.GetSystemAuthentication(IConfigurationCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISystemAuthenticationControl.GetSystemAuthentication<TContext>(TContext,IConfigurationContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IConfigurationCallback.OnReply(ISecurityConfiguration)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IConfigurationCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IConfigurationContextCallback<in TContext>.OnReply(TContext,ISecurityConfiguration)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IConfigurationContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.ISecurityControl.GetSecurity(IConfigurationCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.ISecurityControl.GetSecurity<TContext>(TContext,IConfigurationContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.ISecurityControl`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.ISecurityStoreFeature.UpdateStore(string,IUpdateStoreCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.ISecurityStoreFeature.UpdateStore<TContext>(string,TContext,IUpdateStoreContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IUpdateStoreCallback.OnRejected(IReadOnlyCollection<IErrorReport>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IUpdateStoreCallback.OnSuccess()->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IUpdateStoreCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IUpdateStoreContextCallback<in TContext>.OnSuccess(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IUpdateStoreContextCallback<in TContext>.Unrejected(TContext,IReadOnlyCollection<IErrorReport>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IUpdateStoreContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.UpdateStoreCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.UpdateStoreContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.ISessionPropertiesCallback.OnReply(ISessionId,Dictionary<string,string>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.ISessionPropertiesCallback.OnUnknownSession(ISessionId)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.ISessionPropertiesCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IMissingTopicHandler.OnMissingTopic(IMissingTopicNotification)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IMissingTopicHandler`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionByFilterCallback.OnComplete(int)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionByFilterCallback.OnRejected(ICollection<IErrorReport>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionByFilterCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionByFilterContextCallback<in TC>.OnComplete(TC,int)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionByFilterContextCallback<in TC>.OnRejected(TC,ICollection<IErrorReport>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionByFilterContextCallback<in TC>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionCallback.OnComplete()->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionContextCallback<in TC>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionContextCallback<in TC>OnComplete(TC)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Subscribe(ISessionId,ITopicSelector,ISubscriptionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Subscribe(ISessionId,string,ISubscriptionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Subscribe<TC>(ISessionId,ITopicSelector,TC,ISubscriptionContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Subscribe<TC>(ISessionId,string,TC,ISubscriptionContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilter(string,ITopicSelector,ISubscriptionByFilterCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilter(string,string,ISubscriptionByFilterCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilter<TC>(string,ITopicSelector,TC,ISubscriptionByFilterContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.SubscribeByFilter<TC>(string,string,TC,ISubscriptionByFilterContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Unsubscribe(ISessionId,ITopicSelector,ISubscriptionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Unsubscribe(ISessionId,string,ISubscriptionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Unsubscribe<TC>(ISessionId,ITopicSelector,TC,ISubscriptionContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.Unsubscribe<TC>(ISessionId,string,TC,ISubscriptionContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilter(string,ITopicSelector,ISubscriptionByFilterCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilter(string,string,ISubscriptionByFilterCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilter<TC>(string,ITopicSelector,TC,ISubscriptionByFilterContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.UnsubscribeByFilter<TC>(string,string,TC,ISubscriptionByFilterContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControl.AddMissingTopicHandler(string,IMissingTopicHandler)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControl.AddTopic(string,ITopicSpecification,ITopicControlAddCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControl.AddTopic<TContext>(string, ITopicSpecification,TContext,ITopicControlAddContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControl.NewSpecification(TopicType)->ITopicSpecification`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControl.Remove(string,ITopicControlRemovalCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControl.Remove<TContext>(string,TContext,ITopicControlRemovalContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlAddCallback.OnTopicAdded(string)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlAddCallback.OnTopicAddFailed(string,TopicAddFailReason)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlAddCallback`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlAddContextCallback<in TContext>.OnTopicAdded(TContext,string)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlAddContextCallback<in TContext>.OnTopicAddFailed(TContext,string,TopicAddFailReason)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlAddContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlRemovalCallback.OnTopicsRemoved()->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlRemovalCallback` 
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlRemovalContextCallback<in TContext>.OnTopicsRemoved(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ITopicControlRemovalContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.MissingTopicHandlerDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.SubscriptionByFilterCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.SubscriptionByFilterContextCallbackDefault<TC>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.SubscriptionCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.SubscriptionContextCallbackDefault<TC>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.TopicControlAddCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.TopicControlAddContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.TopicControlRemovalCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.TopicControlRemovalContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.ICallback.OnDiscard()->void`
* `PushTechnology.ClientInterface.Client.Features.ICallback`
* `PushTechnology.ClientInterface.Client.Features.IChangePrincipalCallback.OnAuthenticationFailure()->void`
* `PushTechnology.ClientInterface.Client.Features.IChangePrincipalCallback.OnPrincipalChanged()->void`
* `PushTechnology.ClientInterface.Client.Features.IChangePrincipalContextCallback<in TContext>.OnAuthenticationFailure(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.IChangePrincipalContextCallback<in TContext>.OnPrincipalChanged(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.IChangePrincipalContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.IContextCallback<in TContext>.OnDiscard(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.IContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.IPingCallback.OnPingResponse(IPingDetails)->void`
* `PushTechnology.ClientInterface.Client.Features.IPingCallback`
* `PushTechnology.ClientInterface.Client.Features.IPingContextCallback<in TContext>.OnPingResponse(TContext,IPingDetails)->void`
* `PushTechnology.ClientInterface.Client.Features.IPingContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.IPings.PingServer(IPingCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.IPings.PingServer<TContext>(TContext,IPingContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.ISecurity.ChangePrincipal(string,ICredentials,IChangePrincipalCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.ISecurity.ChangePrincipal<TContext>(string,ICredentials,TContext,IChangePrincipalContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.ISecurity.IChangePrincipalCallback`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Subscribe(ITopicSelector,ITopicsCompletionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Subscribe(string,ITopicsCompletionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Subscribe<TContext>(ITopicSelector,TContext,ITopicsCompletionContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Subscribe<TContext>(string,TContext,ITopicsCompletionContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Unsubscribe(ITopicSelector,ITopicsCompletionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Unsubscribe(string,ITopicsCompletionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Unsubscribe<TContext>(ITopicSelector,TContext,ITopicsCompletionContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopics.Unsubscribe<TContext>(string,TContext,ITopicsCompletionContextCallback<TContext>)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopicsCompletionCallback.OnComplete()->void`
* `PushTechnology.ClientInterface.Client.Features.ITopicsCompletionCallback`
* `PushTechnology.ClientInterface.Client.Features.ITopicsCompletionContextCallback<in TContext>.OnComplete(TContext)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopicsCompletionContextCallback<in TContext>`
* `PushTechnology.ClientInterface.Client.Features.ITopicTreeHandler.OnActive(string,IRegisteredHandler)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopicTreeHandler.OnClose(string)->void`
* `PushTechnology.ClientInterface.Client.Features.ITopicTreeHandler`
* `PushTechnology.ClientInterface.Client.Features.PingCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.PingContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.TopicsCompletionCallbackDefault`
* `PushTechnology.ClientInterface.Client.Features.TopicsCompletionContextCallbackDefault<TContext>`
* `PushTechnology.ClientInterface.Client.Features.TopicTreeHandlerDefault`


## Version 6.11.0

Bugs fixed:

* SessionClosedException was being thrown when the client was not in the closed state. This has now been fixed.
* The dotnet client was ignoring the maximum message size set by the user. This has now been fixed.
* Calling GetSessionPropertiesAsync for a session did not throw NoSuchSessionException when that session was closed. This has now been fixed.

Highlights:

* SetSessionPropertiesListener has been deprecated in favor of AddSessionEventListenerAsync which provides greater functionality and reports on sessions at all cluster members.
* The 'Environment' session property has been added to give the .Net version in which the client is running.
* It is now possible to suppress delta generation in update streams.
* It is now possible to fetch the sizes of topics using the topics fetch feature.
* The Proceed() and Cancel() methods of IMissingTopicNotification deprecated since 6.6 have now been removed.

Added:

* `PushTechnology.ClientInterface.Client.Factories.Diffusion.NewSessionEventParametersBuilder()->ISessionEventParametersBuilder`
* `PushTechnology.ClientInterface.Client.Session.ErrorReportsException`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.AddSessionEventListenerAsync(ISessionEventStream, ISessionEventParameters)->Task<IRegistration>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.AddSessionEventListenerAsync(ISessionEventStream, ISessionEventParameters, CancellationToken)->Task<IRegistration>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStream`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStream.OnSessionEvent(ISessionEventStreamEvent)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SessionEventStreamEventType`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SessionEventStreamEventState`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.SessionId{get;}->ISessionId`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.SessionEventStreamEventType{get;}->SessionEventStreamEventType`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.SessionEventStreamEventState{get;}->SessionEventStreamEventState`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.IsOpenEvent{get;}->bool`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.Properties{get;}->IReadOnlyDictionary<string, string>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.ChangedProperties{get;}->IReadOnlyDictionary<string, string>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventStreamEvent.CloseReason{get;}->CloseReason`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParameters`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParameters.Filter{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParameters.Properties{get;}->HashSet<string>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParameters.After{get;}->DateTime?`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParametersBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParametersBuilder.Filter(string)->ISessionEventParametersBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParametersBuilder.Properties(params string[])->ISessionEventParametersBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParametersBuilder.After(DateTime?)->ISessionEventParametersBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISessionEventParametersBuilder.Build()->ISessionEventParameters`
* `PushTechnology.ClientInterface.Client.Session.SessionProperty.ENVIRONMENT->string`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.SuppressDeltas(bool)->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IFetchRequest.WithSizes()->IFetchRequest`
* `PushTechnology.ClientInterface.Client.Features.ITopicResult.ValueSize{get;}->int`
* `PushTechnology.ClientInterface.Client.Features.ITopicResult.ValueCount{get;}->int`
* `PushTechnology.ClientInterface.Client.Features.ITopicResult.ValueTotalSize{get;}->long`

Deprecated:

* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IClientControl.SetSessionPropertiesListener(ISessionPropertiesListener, params string[])->void`

Removed:

* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IMissingTopicNotification.Proceed()->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IMissingTopicNotification.Cancel()->void`


## Version 6.10.0

Bugs fixed:

* Setting NoReconnection on a .NET session did not disable reconnection. This has now been fixed.
* The dotnet client incorrectly accepted empty strings as valid JSON. This has now been fixed.

Highlights:

* The dotnet client can now convert a session ID from a string with the SessionIdFromString method.
* TopicPermission was deprecated at release 6.5 in favor of PathPermission. It has been removed at this release along with all associated methods.
* The dotnet client provides the ability for Primary servers to initiate Remote Server connections.
* Routing topic type has been removed.
* The UpdateConstraint API has been extended to allow for conditional constraints which can check the value of a topic or JSON field using operators like GT (greater than), LT (less than) etc.
* The update stream builder now allows a IRecoverableUpdateStream to be created that can be used to recover automatically from transient clustering exceptions.
* It is now possible to form compound update constraints using an 'or' operator as well as 'and'.
* The dotnet client provides the ability to retrieve metrics using the API.

Added:

* `PushTechnology.ClientInterface.Client.Features.Control.Clients.RemoteServerType`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.RemoteServerType{get;}->RemoteServerType`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServerBuilder<T>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServerBuilder<T>.Reset()->T`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiator`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiator.Urls{get;}->List<string>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiator.Connector{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiator.RetryDelay{get;}->int`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiatorBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiatorBuilder.RetryDelay(int)->IPrimaryInitiatorBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IPrimaryInitiatorBuilder.Build(string,List<string>,string)->IPrimaryInitiator`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryServer`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryServer.ServerUrl{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryServer.Principal{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryServer.ConnectionOptions{get;}->Dictionary<RemoteServerConnectionOption, string>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryServer.MissingTopicNotificationFilter{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryBuilder<T>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryBuilder<T>.Principal(string)->T`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryBuilder<T>.Credentials(ICredentials)->T`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryBuilder<T>.ConnectionOptions(Dictionary<RemoteServerConnectionOption, string>)->T`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryBuilder<T>.ConnectionOption(RemoteServerConnectionOption,string)->T`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryBuilder<T>.MissingTopicNotificationFilter(string)->T`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryInitiator`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryInitiator.ServerUrl{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryInitiatorBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryInitiatorBuilder.Build(string,string)->ISecondaryInitiator`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryAcceptor`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryAcceptor.PrimaryHostName{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryAcceptorBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.ISecondaryAcceptorBuilder.Build(string,string)->ISecondaryAcceptor`
* `PushTechnology.ClientInterface.Client.Factories.Diffusion<T>`
* `PushTechnology.ClientInterface.Client.Factories.Diffusion<T>.NewRemoteServerBuilder(RemoteServerType)->IRemoteServerBuilder<T>`
* `PushTechnology.ClientInterface.Client.Features.UpdateConstraintOperator`
* `PushTechnology.ClientInterface.Client.Features.IPartialJSON.With<TValue>(string,UpdateConstraintOperator,TValue)->IPartialJSON`
* `PushTechnology.ClientInterface.Client.Features.IUpdateConstraintFactory.Value<TValue>(UpdateConstraintOperator,TValue)->IUpdateConstraint`
* `PushTechnology.ClientInterface.Client.Features.IUpdateConstraint.Or(IUpdateConstraint)->IUpdateConstraint`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Build<TValue>(string,RetryStrategy)->IRecoverableUpdateStream<TValue>`
* `PushTechnology.ClientInterface.Client.Features.IRecoverableUpdateStream<TValue>`
* `PushTechnology.ClientInterface.Client.Features.IRecoverableUpdateStream<TValue>.IsRecoverable{get;}->bool`
* `PushTechnology.ClientInterface.Client.Features.IRecoverableUpdateStream<TValue>.RecoverAsync()->Task`
* `PushTechnology.ClientInterface.Client.Features.IRecoverableUpdateStream<TValue>.RecoverAsync(CancellationToken)->Task`
* `PushTechnology.ClientInterface.Client.Features.Metrics.MetricsRequest()->IMetricsRequest`
* `PushTechnology.ClientInterface.Client.Features.Metrics.MetricType`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSample`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSample.Name{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSample.LabelNames{get;}->List<string>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSample.LabelValues{get;}->List<string>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSample.Timestamp{get;}->long?`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSample.Value{get;}->double`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSampleCollection`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSampleCollection.Name{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSampleCollection.Type{get;}->MetricType`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSampleCollection.Unit{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricSampleCollection.Samples{get;}->List<IMetricSample>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest.Filter(HashSet<string>)->IMetricsRequest`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest.Filter(string)->IMetricsRequest`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest.Server(string)->IMetricsRequest`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest.CurrentServer{get;}->IMetricsRequest`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest.FetchAsync()->Task<IMetricsResult>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsRequest.FetchAsync(CancellationToken)->Task<IMetricsResult>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsResult`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsResult.ServerNames{get;}->HashSet<string>`
* `PushTechnology.ClientInterface.Client.Features.Metrics.IMetricsResult.GetMetrics(string)->List<IMetricSampleCollection>`

Removed:

* `PushTechnology.ClientInterface.Client.Features.Control.Topics.INCOMPATIBLE_PARENT`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IncompatibleParentTopicException`
* `PushTechnology.ClientInterface.Client.Features.ISecurity.GetPathPermissionsAsync(string)->Task<IReadOnlyCollection<TopicPermission>>`
* `PushTechnology.ClientInterface.Client.Features.ISecurity.GetPathPermissionsAsync(string,CancellationToken)->Task<IReadOnlyCollection<TopicPermission>>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IRole.DefaultTopicPermissions{get;}->IReadOnlyCollection<TopicPermission>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IRole.TopicPermissions{get;}->IReadOnlyDictionary<string,IReadOnlyCollection<TopicPermission>>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IScriptBuilder.SetDefaultTopicPermissions(string,IEnumerable<TopicPermission>)->IScriptBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IScriptBuilder.SetTopicPermissions(string,string,IEnumerable<TopicPermission>)->IScriptBuilder`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.SecurityControl.IScriptBuilder.RemoveTopicPermissions(string,string)->IScriptBuilder`
* `PushTechnology.ClientInterface.Security.GeneralTopicPermissions{get;}->IReadOnlyDictionary<string, IReadOnlyCollection<TopicPermission>>`
* `PushTechnology.ClientInterface.Client.Types.TopicPermission`
* `PushTechnology.ClientInterface.Client.Topics.TopicType.ROUTING`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.ISubscriptionControl.AddRoutingSubscriptionHandler(string,IRoutingSubscriptionRequestHandler)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequest`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequest.SessionId{get;}->ISessionId`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequest.TopicPath{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequest.Defer()->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequest.Route(string,ISubscriptionCallback)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequest.Route<TC>(string,TC,ISubscriptionContextCallback<TC>)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequestHandler`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.IRoutingSubscriptionRequestHandler.OnSubscriptionRequest(IRoutingSubscriptionRequest)->void`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.RoutingSubscriptionRequestHandlerDefault`
* `PushTechnology.ClientInterface.Client.Features.Control.Topics.RoutingSubscriptionRequestHandlerDefault.OnSubscriptionRequest(IRoutingSubscriptionRequest)->void` 
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Retry(int,int,int)->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.NoRetry()->IUpdateStreamBuilder`

Deprecated:

* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServer.Principal{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServer.ServerUrl{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServer.MissingTopicNotificationFilter{get;}->string`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServer.ConnectionOptions{get;}->Dictionary<RemoteServerConnectionOption, string>`
* `PushTechnology.ClientInterface.Client.Features.Control.Clients.IRemoteServerBuilder`
* `PushTechnology.ClientInterface.Client.Factories.NewRemoteServerBuilder()->IRemoteServerBuilder`
* `PushTechnology.ClientInterface.Client.Features.IPartialJSON.With<TValue>(string,TValue)->IPartialJSON`


## Version 6.9.0

Bugs fixed:

* The performance of topic updates can vary considerably across sessions. This has been fixed.

Highlights:

* The dotnet client is able to automatically retry the initial connection to the server if it fails.
* The IFilteredRequestCallback interface used in the IMessaging.SendRequestToFilterAsync method no longer inherits from the Callbacks.IStream interface.
* The Topic metric collector now has a property for grouping by topic views.

Changes:

* `PushTechnology.ClientInterface.Client.Features.IFilteredRequestCallback<TResponse> no longer inherits from Callbacks.IStream`

Added:

* `PushTechnology.ClientInterface.Client.Features.ITopicUpdate.NewUpdateStreamBuilder()->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Specification( ITopicSpecification topicSpecification )->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Constraint( IUpdateConstraint updateConstraint )->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Retry( int retryInterval, int numberOfRetries, int bufferSize )->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Reset()->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.NoRetry()->IUpdateStreamBuilder`
* `PushTechnology.ClientInterface.Client.Features.IUpdateStreamBuilder.Build<TValue>( string path )->IUpdateStream<TValue>`
* `PushTechnology.ClientInterface.Client.Session.ISessionAttributes.InitialRetryStrategy{get;}->RetryStrategy`
* `PushTechnology.ClientInterface.Client.Session.ISessionFactory.InitialRetryStrategy( RetryStrategy strategy )->ISessionFactory`
* `PushTechnology.ClientInterface.Client.Session.RetryStrategy`
* `PushTechnology.ClientInterface.Client.Session.RetryStrategy.NO_RETRY`
* `PushTechnology.ClientInterface.Client.Session.RetryStrategy.Interval{get;}->int`
* `PushTechnology.ClientInterface.Client.Session.RetryStrategy.Attempts{get;}->int`
* `PushTechnology.ClientInterface.Client.Features.Metrics.ITopicMetricCollector.GroupsByTopicView{get;}->bool`
* `PushTechnology.ClientInterface.Client.Features.Metrics.ITopicMetricCollectorBuilder.GroupByTopicView( bool groupByTopicView )->ITopicMetricCollectorBuilder`

Removed:

* `PushTechnology.ClientInterface.Client.Features.IFilteredRequestCallback<TResponse>.OnClose()->void`
* `PushTechnology.ClientInterface.Client.Features.IFilteredRequestCallback<TResponse>.OnError( ErrorReason errorReason )->void`

Deprecated:

* `PushTechnology.ClientInterface.Client.Features.ITopicUpdate.CreateUpdateStream<TValue>( string path )->IUpdateStream<TValue>`
* `PushTechnology.ClientInterface.Client.Features.ITopicUpdate.CreateUpdateStream<TValue>( string path, IUpdateConstraint constraint )->IUpdateStream<TValue>`
* `PushTechnology.ClientInterface.Client.Features.ITopicUpdate.CreateUpdateStream<TValue>( string path, ITopicSpecification specification )->IUpdateStream<TValue>`
* `PushTechnology.ClientInterface.Client.Features.ITopicUpdate.CreateUpdateStream<TValue>( string path, ITopicSpecification specification, IUpdateConstraint constraint )->IUpdateStream<TValue>`
