#ifndef _diffusion_topic_selection_h_
#define _diffusion_topic_selection_h_ 1

/*
 * Copyright © 2025 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 */

/**
 * @file topic-selection.h
 *
 * A topic selection is a pair comprised of a topic selector expression and a selection type.
 *
 * @since 6.12
 */

 /**
  * Enumeration for the topic selection types
  */
 typedef enum {
    DIFFUSION_TOPIC_SELECTION_TYPE_SELECT = 0,
    DIFFUSION_TOPIC_SELECTION_TYPE_DESELECT = 1
} DIFFUSION_TOPIC_SELECTION_TYPE_T;


/**
 * Structure of the topic selection
 */
typedef struct diffusion_topic_selection_s
{
    char *topic_selector_expression;
    DIFFUSION_TOPIC_SELECTION_TYPE_T type;
} DIFFUSION_TOPIC_SELECTION_T;

#endif
