/*
 * @file deprecate.h
 *
 * Macros to be used when deprecating functions.
 *
 * Copyright © 2018 - 2024 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 */

#ifndef _diffusion_deprecate_h_
#define _diffusion_deprecate_h_ 1


#if (defined __GNUC__) || (defined __llvm__)
    #if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 6)
        #define DEPRECATED(FUNC) FUNC __attribute__((deprecated))
    #else
        #define DEPRECATED(FUNC) FUNC __attribute__((deprecated))
    #endif
#elif defined(_MSC_VER)
    #define DEPRECATED(FUNC) __declspec(deprecated) FUNC
#else
    #define DEPRECATED(FUNC) FUNC; /* passthrough */
#endif


#if (defined __GNUC__) || (defined __llvm__)
    #define ATTR_DEPRECATED __attribute__((deprecated))
#else
    #define ATTR_DEPRECATED /* passthrough */
#endif


#if (defined __llvm__)
    #define ENUM_DEPRECATED(msg) __deprecated_enum_msg(msg)
#else
    #define ENUM_DEPRECATED(msg) __attribute__((deprecated(msg)))
#endif


#if (defined __GNUC__) || (defined __llvm__)
    #define TYPEDEF_DEPRECATED(RETURN_TYPE, FUNC) typedef RETURN_TYPE __attribute__((deprecated)) FUNC;
#elif defined(_MSC_VER)
    #define TYPEDEF_DEPRECATED(RETURN_TYPE, FUNC) typedef __declspec(deprecated) RETURN_TYPE FUNC;
#else
    #define TYPEDEF_DEPRECATED(RETURN_TYPE, FUNC) typedef RETURN_TYPE FUNC; /* passthrough */
#endif


#endif
