#ifndef _diffusion_doxygen_defs_h_
#define _diffusion_doxygen_defs_h_ 1

/**
 * @defgroup PublicAPI_Session Session management
 * Establishing sessions with the Diffusion Server.
 *
 *
 * @defgroup PublicAPI_PubSub Publishing and Subscribing
 * Features responsible for subscribing to topics, their datatypes and updating them.
 *
 * @defgroup PublicAPI_Topics Topics
 * @ingroup PublicAPI_PubSub
 *
 * @defgroup PublicAPI_TopicUpdate Topic Update
 * @ingroup PublicAPI_PubSub
 *
 * @defgroup PublicAPI_TimeSeries Time Series
 * @ingroup PublicAPI_PubSub
 *
 * @defgroup PublicAPI_FetchRequest Fetch Request
 * @ingroup PublicAPI_PubSub
 *
 *
 * @defgroup PublicAPI_TopicDatatypes Topic Datatypes
 * @ingroup PublicAPI_PubSub
 *
 * @defgroup PublicAPI_TopicDatatypes_Binary Binary
 * @ingroup PublicAPI_TopicDatatypes
 *
 * @defgroup PublicAPI_TopicDatatypes_Double Double
 * @ingroup PublicAPI_TopicDatatypes
 *
 * @defgroup PublicAPI_TopicDatatypes_Int64 Int64
 * @ingroup PublicAPI_TopicDatatypes
 *
 * @defgroup PublicAPI_TopicDatatypes_JSON JSON
 * @ingroup PublicAPI_TopicDatatypes
 *
 * @defgroup PublicAPI_TopicDatatypes_RecordV2 RecordV2
 * @ingroup PublicAPI_TopicDatatypes
 *
 * @defgroup PublicAPI_TopicDatatypes_String String
 * @ingroup PublicAPI_TopicDatatypes
 *
 *
 * @defgroup PublicAPI_Messaging Messaging
 *
 *
 * @defgroup PublicAPI_TopicManagement Topic Management
 * Topic creation and monitoring topic tree related events.
 *
 * @defgroup PublicAPI_TopicControl Topic Control
 * @ingroup PublicAPI_TopicManagement
 *
 * @defgroup PublicAPI_TopicNotifications Topic Notifications
 * @ingroup PublicAPI_TopicManagement
 *
 *
 * @defgroup PublicAPI_Wrangling Wrangling
 * Management of topic wrangling capabilities.
 *
 * @defgroup PublicAPI_TopicViews Topic Views
 * @ingroup PublicAPI_Wrangling
 *
 * @defgroup PublicAPI_SessionTrees Session Trees
 * @ingroup PublicAPI_Wrangling
 *
 *
 * @defgroup PublicAPI_SessionManagement Session Management
 * Management of other client sessions.
 *
 * @defgroup PublicAPI_Security Security
 * @ingroup PublicAPI_SessionManagement
 *
 * @defgroup PublicAPI_SubscriptionControl Subscription Control
 * @ingroup PublicAPI_SessionManagement
 *
 * @defgroup PublicAPI_ClientControl Client Control
 * @ingroup PublicAPI_SessionManagement
 *
 *
 * @defgroup PublicAPI_ServerConfiguration Server Configuration
 * Management of server configuration.
 *
 * @defgroup PublicAPI_AuthenticationControl Authentication Control
 * @ingroup PublicAPI_ServerConfiguration
 *
 * @defgroup PublicAPI_SystemAuthenticationControl System Authentication Control
 * @ingroup PublicAPI_ServerConfiguration
 *
 * @defgroup PublicAPI_SecurityControl Security Control
 * @ingroup PublicAPI_ServerConfiguration
 *
 * @defgroup PublicAPI_RemoteServers Remote Servers
 * @ingroup PublicAPI_ServerConfiguration
 *
 * @defgroup PublicAPI_Metrics Metrics
 * @ingroup PublicAPI_ServerConfiguration
 *
 *
 * @defgroup PublicAPI_Ping Ping
 *

 *
 *
 * @mainpage
 *
 *
 * ### Core functionality
 * - @ref PublicAPI_Session
 * - @ref PublicAPI_PubSub
 * - @ref PublicAPI_Messaging
 * - @ref PublicAPI_Ping
 * - @ref PublicAPI_TopicDatatypes
 *
 *
 * ### Advanced functionality
 * - @ref PublicAPI_Wrangling
 * - @ref PublicAPI_TopicManagement
 *
 *
 * ### Client control functionality
 * - @ref PublicAPI_SessionManagement
 * - @ref PublicAPI_ServerConfiguration
 *
 * ---
 *
 * ## Links
 *
 * ### Additional Documentation
 * - [Quickstart Guide](https://docs.diffusiondata.com/docs/quickstartguide/onprem/index-on-prem.html)
 * - [Latest Diffusion Release Notes](https://docs.diffusiondata.com/docs/latest/ReleaseNotice.html)
 * - [Diffusion User Manual](https://docs.diffusiondata.com/docs/latest/manual/html/index.html)
 *
 *
 * ### Support Links
 * - [Download Diffusion C SDK](https://www.diffusiondata.com/diffusion-on-premise/#c)
 * - [DiffusionData Developer Hub](https://docs.diffusiondata.com/)
 * - [DiffusionData Homepage](https://www.diffusiondata.com/)
 *
 */

#endif
