#ifndef _diffusion_h_
#define _diffusion_h_ 1

/*
 * Copyright © 2014 - 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 */

/**
 * @file diffusion.h
 *
 * Main include file.
 */
#ifdef __cplusplus
extern "C"
{
#endif

#include "doxygen-defs.h"

#ifndef APR_DECLARE_STATIC
    #define APR_DECLARE_STATIC 1
#endif
#ifndef APU_DECLARE_STATIC
    #define APU_DECLARE_STATIC 1
#endif

/** The version of Diffusion from which the C API library was built. */
#if defined(__GNUC__)
    static const char *DIFFUSION_VERSION __attribute__((unused)) = "6.12.1#a2f29cd1";
#else
static const char *DIFFUSION_VERSION = "6.12.1#a2f29cd1";
#endif

#include <stdlib.h>

#include "apr.h"
#include "cbor.h"
#include "conversation.h"
#include "datatypes.h"
#include "diffusion-api-error.h"
#include "error.h"
#include "features/authentication-control.h"
#include "features/client-control.h"
#include "features/messaging.h"
#include "features/metrics.h"
#include "features/pings.h"
#include "features/remote-servers.h"
#include "features/security-control.h"
#include "features/security.h"
#include "features/session-trees.h"
#include "features/subscription-control.h"
#include "features/system-authentication-control.h"
#include "features/time-series.h"
#include "features/topic-control.h"
#include "features/topic-notifications.h"
#include "features/topic-update.h"
#include "features/topic-views.h"
#include "features/topics.h"
#include "hash.h"
#include "hash_num.h"
#include "registration.h"
#include "security.h"
#include "session-lock.h"
#include "session.h"
#include "streams.h"
#include "topic-selector.h"
#include "topic-specification.h"
#include "topic.h"
#include "update-constraint-value.h"
#include "update-constraint.h"
#include "value-stream.h"

#ifdef __cplusplus
}
#endif

#endif
