/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.lifecycle;

import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.lifecycle.LifecycleState;
import java.io.Serializable;

public class DefaultLifecycleState
implements LifecycleState,
Serializable {
    private static final String CONSTRUCTED = "CONSTRUCTED";
    private static final String STARTED = "STARTED";
    private static final String STOPPED = "STOPPED";
    private static final String DISPOSED = "DISPOSED";
    private String state = "CONSTRUCTED";

    public void removingComponent() {
        if (this.isStarted()) {
            throw new PicoCompositionException("Cannot remove components after the container has started");
        }
        if (this.isDisposed()) {
            throw new PicoCompositionException("Cannot remove components after the container has been disposed");
        }
    }

    public void starting() {
        if (this.isConstructed() || this.isStopped()) {
            this.state = STARTED;
            return;
        }
        throw new IllegalStateException("Cannot start.  Current container state was: " + this.state);
    }

    public void stopping() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot stop.  Current container state was: " + this.state);
        }
    }

    public void stopped() {
        this.state = STOPPED;
    }

    public boolean isStarted() {
        return this.state == STARTED;
    }

    public void disposing() {
        if (!this.isStopped() && !this.isConstructed()) {
            throw new IllegalStateException("Cannot dispose.  Current lifecycle state is: " + this.state);
        }
    }

    public void disposed() {
        this.state = DISPOSED;
    }

    public boolean isDisposed() {
        return this.state == DISPOSED;
    }

    public boolean isStopped() {
        return this.state == STOPPED;
    }

    public boolean isConstructed() {
        return this.state == CONSTRUCTED;
    }
}

