/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.injectors;

import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.Parameter;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.annotations.Bind;
import com.pushtechnology.repackaged.picocontainer.injectors.AbstractInjector;
import com.pushtechnology.repackaged.picocontainer.injectors.ParameterNameBinding;
import com.pushtechnology.repackaged.picocontainer.injectors.PrimitiveMemberChecker;
import com.pushtechnology.repackaged.picocontainer.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;

public abstract class SingleMemberInjector<T>
extends AbstractInjector<T> {
    public SingleMemberInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames) {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
    }

    protected Paranamer getParanamer() {
        return null;
    }

    protected Object[] getMemberArguments(PicoContainer container, AccessibleObject member, Type[] parameterTypes, Annotation[] bindings) {
        this.boxParameters(parameterTypes);
        Object[] result = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes.length);
        for (int i = 0; i < currentParameters.length; ++i) {
            result[i] = this.getParameter(container, member, i, parameterTypes[i], bindings[i], currentParameters[i], null);
        }
        return result;
    }

    protected void boxParameters(Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.box(parameterTypes[i]);
        }
    }

    protected Object getParameter(PicoContainer container, AccessibleObject member, int i, Type parameterType, Annotation binding, Parameter currentParameter, ComponentAdapter<?> injecteeAdapter) {
        ParameterNameBinding expectedNameBinding = new ParameterNameBinding(this.getParanamer(), member, i);
        Object result = null;
        try {
            result = currentParameter.resolve(container, this, injecteeAdapter, parameterType, expectedNameBinding, this.useNames(), binding).resolveInstance();
        }
        catch (AbstractInjector.AmbiguousComponentResolutionException e) {
            e.setMember(member);
            throw e;
        }
        this.nullCheck(member, i, expectedNameBinding, result);
        return result;
    }

    protected void nullCheck(AccessibleObject member, int i, ParameterNameBinding expectedNameBinding, Object result) {
        if (result == null && !this.isNullParamAllowed(member, i)) {
            throw new ParameterCannotBeNullException(i, member, expectedNameBinding.getName());
        }
    }

    protected boolean isNullParamAllowed(AccessibleObject member, int i) {
        return !PrimitiveMemberChecker.isPrimitiveArgument(member, i);
    }

    protected Annotation[] getBindings(Annotation[][] annotationss) {
        Annotation[] retVal = new Annotation[annotationss.length];
        block0: for (int i = 0; i < annotationss.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationss[i]) {
                if (annotation.annotationType().getAnnotation(Bind.class) == null) continue;
                retVal[i] = annotation;
                continue block0;
            }
        }
        return retVal;
    }

    public static class ParameterCannotBeNullException
    extends PicoCompositionException {
        private final String name;

        private ParameterCannotBeNullException(int ix, AccessibleObject member, String name) {
            super("Parameter " + ix + " of '" + String.valueOf(member) + "' named '" + name + "' cannot be null");
            this.name = name;
        }

        public String getParameterName() {
            return this.name;
        }
    }
}

