/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.injectors;

import com.pushtechnology.repackaged.picocontainer.Characteristics;
import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.Injector;
import com.pushtechnology.repackaged.picocontainer.LifecycleStrategy;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoVisitor;
import com.pushtechnology.repackaged.picocontainer.injectors.MethodInjection;
import com.pushtechnology.repackaged.picocontainer.injectors.Provider;
import com.pushtechnology.repackaged.picocontainer.injectors.Reinjector;
import com.pushtechnology.repackaged.picocontainer.lifecycle.NullLifecycleStrategy;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderAdapter
implements Injector,
Provider,
LifecycleStrategy {
    private final Provider provider;
    private final Method provideMethod;
    private final Class key;
    private Properties properties;
    private LifecycleStrategy lifecycleStrategy;

    protected ProviderAdapter() {
        this.provider = this;
        this.provideMethod = ProviderAdapter.getProvideMethod(this.getClass());
        this.key = this.provideMethod.getReturnType();
        this.setUseNames(this.useNames());
        this.lifecycleStrategy = new NullLifecycleStrategy();
    }

    public ProviderAdapter(LifecycleStrategy lifecycleStrategy, Provider provider) {
        this(lifecycleStrategy, provider, false);
    }

    public ProviderAdapter(Provider provider) {
        this(new NullLifecycleStrategy(), provider, false);
    }

    public ProviderAdapter(Provider provider, boolean useNames) {
        this(new NullLifecycleStrategy(), provider, useNames);
    }

    public ProviderAdapter(LifecycleStrategy lifecycleStrategy, Provider provider, boolean useNames) {
        this.lifecycleStrategy = lifecycleStrategy;
        this.provider = provider;
        this.provideMethod = ProviderAdapter.getProvideMethod(provider.getClass());
        this.key = this.provideMethod.getReturnType();
        this.setUseNames(useNames);
    }

    private void setUseNames(boolean useNames) {
        this.properties = useNames ? Characteristics.USE_NAMES : Characteristics.NONE;
    }

    protected boolean useNames() {
        return false;
    }

    public Object decorateComponentInstance(PicoContainer container, Type into, Object instance) {
        return null;
    }

    @Override
    public Object getComponentKey() {
        return this.key;
    }

    @Override
    public Class getComponentImplementation() {
        return this.key;
    }

    @Override
    @Deprecated
    public Object getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        return new Reinjector(container).reinject(this.key, this.provider.getClass(), this.provider, this.properties, new MethodInjection(this.provideMethod));
    }

    public static Method getProvideMethod(Class clazz) {
        Method provideMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals("provide")) continue;
            if (provideMethod != null) {
                throw ProviderAdapter.newProviderMethodException("only one");
            }
            provideMethod = method;
        }
        if (provideMethod == null) {
            throw ProviderAdapter.newProviderMethodException("a");
        }
        if (provideMethod.getReturnType() == Void.TYPE) {
            throw ProviderAdapter.newProviderMethodException("a non void returning");
        }
        return provideMethod;
    }

    private static PicoCompositionException newProviderMethodException(String str) {
        return new PicoCompositionException("There must be " + str + " method named 'provide' in the AbstractProvider implementation");
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
    }

    @Override
    public void accept(PicoVisitor visitor) {
    }

    @Override
    public ComponentAdapter getDelegate() {
        return null;
    }

    @Override
    public ComponentAdapter findAdapterOfType(Class adapterType) {
        return null;
    }

    @Override
    public String getDescriptor() {
        return "ProviderAdapter";
    }

    @Override
    public void start(Object component) {
        this.lifecycleStrategy.start(component);
    }

    @Override
    public void stop(Object component) {
        this.lifecycleStrategy.stop(component);
    }

    @Override
    public void dispose(Object component) {
        this.lifecycleStrategy.dispose(component);
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        return this.lifecycleStrategy.hasLifecycle(type);
    }

    @Override
    public boolean isLazy(ComponentAdapter<?> adapter) {
        return this.lifecycleStrategy.isLazy(adapter);
    }
}

