/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.injectors;

import com.pushtechnology.repackaged.picocontainer.Characteristics;
import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.LifecycleStrategy;
import com.pushtechnology.repackaged.picocontainer.Parameter;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.behaviors.AbstractBehaviorFactory;
import com.pushtechnology.repackaged.picocontainer.injectors.AbstractInjectionFactory;
import com.pushtechnology.repackaged.picocontainer.injectors.MethodInjector;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjection
extends AbstractInjectionFactory {
    private final AbstractInjectionFactory delegate;

    public MethodInjection(String injectionMethodName) {
        this.delegate = new MethodInjectionByName(injectionMethodName);
    }

    public MethodInjection(String ... injectionMethodNames) {
        this.delegate = new MethodInjectionByName(injectionMethodNames);
    }

    public MethodInjection() {
        this("inject");
    }

    public MethodInjection(Method injectionMethod) {
        this.delegate = new MethodInjectionByReflectionMethod(injectionMethod);
    }

    @Override
    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        return this.delegate.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInjectionByReflectionMethod
    extends AbstractInjectionFactory {
        private final Method injectionMethod;

        public MethodInjectionByReflectionMethod(Method injectionMethod) {
            this.injectionMethod = injectionMethod;
        }

        @Override
        public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
            boolean useNames = AbstractBehaviorFactory.arePropertiesPresent(componentProperties, Characteristics.USE_NAMES, true);
            if (this.injectionMethod.getDeclaringClass().isAssignableFrom(componentImplementation)) {
                return this.wrapLifeCycle(monitor.newInjector(new MethodInjector.ByReflectionMethod(componentKey, componentImplementation, parameters, monitor, this.injectionMethod, useNames)), lifecycleStrategy);
            }
            throw new PicoCompositionException("method [" + this.injectionMethod + "] not on impl " + componentImplementation.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInjectionByName
    extends AbstractInjectionFactory {
        private final Set<String> injectionMethodNames = new HashSet<String>();

        public MethodInjectionByName(String ... injectionMethodNames) {
            for (String injectionMethodName : injectionMethodNames) {
                this.injectionMethodNames.add(injectionMethodName);
            }
        }

        public MethodInjectionByName(String injectionMethodName) {
            this.injectionMethodNames.add(injectionMethodName);
        }

        @Override
        public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
            boolean useNames = AbstractBehaviorFactory.arePropertiesPresent(componentProperties, Characteristics.USE_NAMES, true);
            return this.wrapLifeCycle(new MethodInjector.ByMethodName(componentKey, componentImplementation, parameters, monitor, this.injectionMethodNames, useNames), lifecycleStrategy);
        }
    }
}

