/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.injectors;

import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.Injector;
import com.pushtechnology.repackaged.picocontainer.Parameter;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoVisitor;
import com.pushtechnology.repackaged.picocontainer.injectors.AbstractInjector;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInjector<T>
extends AbstractInjector<T> {
    private final Injector<T>[] injectors;

    public CompositeInjector(Object componentKey, Class<?> componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames, Injector ... injectors) {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
        this.injectors = injectors;
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Object instance = null;
        for (Injector<T> injector : this.injectors) {
            if (instance == null) {
                instance = injector.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
                continue;
            }
            injector.decorateComponentInstance(container, into, instance);
        }
        return instance;
    }

    @Override
    public Object decorateComponentInstance(PicoContainer container, Type into, T instance) {
        Object result = null;
        for (Injector<T> injector : this.injectors) {
            result = injector.decorateComponentInstance(container, into, instance);
        }
        return result;
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
        for (Injector<T> injector : this.injectors) {
            injector.verify(container);
        }
    }

    @Override
    public final void accept(PicoVisitor visitor) {
        super.accept(visitor);
        for (Injector<T> injector : this.injectors) {
            injector.accept(visitor);
        }
    }

    @Override
    public String getDescriptor() {
        StringBuilder sb = new StringBuilder("CompositeInjector(");
        for (Injector<T> injector : this.injectors) {
            sb.append(injector.getDescriptor());
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().replace("-", "+") + ")-";
    }
}

