/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.converters;

import com.pushtechnology.repackaged.picocontainer.Converters;
import com.pushtechnology.repackaged.picocontainer.converters.BooleanConverter;
import com.pushtechnology.repackaged.picocontainer.converters.ByteConverter;
import com.pushtechnology.repackaged.picocontainer.converters.CharacterConverter;
import com.pushtechnology.repackaged.picocontainer.converters.Converter;
import com.pushtechnology.repackaged.picocontainer.converters.DoubleConverter;
import com.pushtechnology.repackaged.picocontainer.converters.FileConverter;
import com.pushtechnology.repackaged.picocontainer.converters.FloatConverter;
import com.pushtechnology.repackaged.picocontainer.converters.IntegerConverter;
import com.pushtechnology.repackaged.picocontainer.converters.LongConverter;
import com.pushtechnology.repackaged.picocontainer.converters.ShortConverter;
import com.pushtechnology.repackaged.picocontainer.converters.UrlConverter;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInConverters
implements Converters,
Serializable {
    private final Map<Class<?>, Converter<?>> converters = new HashMap();

    public BuiltInConverters() {
        this.addBuiltInConverters();
    }

    protected void addBuiltInConverters() {
        this.addMultiTypeConverter(new IntegerConverter(), Integer.class, Integer.TYPE);
        this.addMultiTypeConverter(new DoubleConverter(), Double.class, Double.TYPE);
        this.addMultiTypeConverter(new BooleanConverter(), Boolean.class, Boolean.TYPE);
        this.addMultiTypeConverter(new LongConverter(), Long.class, Long.TYPE);
        this.addMultiTypeConverter(new FloatConverter(), Float.class, Float.TYPE);
        this.addMultiTypeConverter(new CharacterConverter(), Character.class, Character.TYPE);
        this.addMultiTypeConverter(new ByteConverter(), Byte.class, Byte.TYPE);
        this.addMultiTypeConverter(new ShortConverter(), Short.class, Short.TYPE);
        this.addConverter(new FileConverter(), File.class);
        this.addConverter(new UrlConverter(), URL.class);
    }

    private void addMultiTypeConverter(Converter<?> converter, Class<?> ... types) {
        for (Class<?> type : types) {
            this.addConverter(converter, type);
        }
    }

    protected void addConverter(Converter<?> converter, Class<?> key) {
        this.converters.put(key, converter);
    }

    @Override
    public boolean canConvert(Type type) {
        return this.converters.containsKey(type);
    }

    @Override
    public Object convert(String paramValue, Type type) {
        Converter<?> converter = this.converters.get(type);
        if (converter == null) {
            return null;
        }
        return converter.convert(paramValue);
    }
}

