/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.behaviors;

import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.behaviors.AbstractBehavior;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenImplementation<T>
extends AbstractBehavior<T> {
    public HiddenImplementation(ComponentAdapter<T> delegate) {
        super(delegate);
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Class[] classes;
        ComponentAdapter delegate = this.getDelegate();
        Object componentKey = delegate.getComponentKey();
        if (componentKey instanceof Class && ((Class)delegate.getComponentKey()).isInterface()) {
            classes = new Class[]{(Class)delegate.getComponentKey()};
        } else if (componentKey instanceof Class[]) {
            classes = (Class[])componentKey;
        } else {
            return delegate.getComponentInstance(container, into);
        }
        this.verifyInterfacesOnly(classes);
        return this.createProxy(classes, container, delegate.getComponentImplementation().getClassLoader());
    }

    @Override
    public String getDescriptor() {
        return "Hidden";
    }

    protected T createProxy(Class[] interfaces, PicoContainer container, ClassLoader classLoader) {
        final PicoContainer container1 = container;
        return (T)Proxy.newProxyInstance(classLoader, interfaces, new InvocationHandler(){
            private final PicoContainer container;
            private volatile Object instance;
            {
                this.container = container1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.instance == null) {
                    HiddenImplementation hiddenImplementation = HiddenImplementation.this;
                    synchronized (hiddenImplementation) {
                        if (this.instance == null) {
                            this.instance = HiddenImplementation.this.getDelegate().getComponentInstance(this.container, (Type)((Object)ComponentAdapter.NOTHING.class));
                        }
                    }
                }
                return HiddenImplementation.this.invokeMethod(this.instance, method, args, this.container);
            }
        });
    }

    protected Object invokeMethod(Object componentInstance, Method method, Object[] args, PicoContainer container) throws Throwable {
        ComponentMonitor componentMonitor = this.currentMonitor();
        try {
            componentMonitor.invoking(container, this, method, componentInstance, args);
            long startTime = System.currentTimeMillis();
            Object rv = method.invoke(componentInstance, args);
            componentMonitor.invoked(container, this, method, componentInstance, System.currentTimeMillis() - startTime, args, rv);
            return rv;
        }
        catch (InvocationTargetException ite) {
            componentMonitor.invocationFailed(method, componentInstance, ite);
            throw ite.getTargetException();
        }
    }

    private void verifyInterfacesOnly(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) continue;
            throw new PicoCompositionException("Class keys must be interfaces. " + clazz + " is not an interface.");
        }
    }
}

