/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.behaviors;

import com.pushtechnology.repackaged.picocontainer.BehaviorFactory;
import com.pushtechnology.repackaged.picocontainer.Characteristics;
import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentFactory;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.LifecycleStrategy;
import com.pushtechnology.repackaged.picocontainer.Parameter;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoVisitor;
import com.pushtechnology.repackaged.picocontainer.annotations.Cache;
import com.pushtechnology.repackaged.picocontainer.behaviors.AbstractBehaviorFactory;
import com.pushtechnology.repackaged.picocontainer.behaviors.Automating;
import com.pushtechnology.repackaged.picocontainer.behaviors.Caching;
import com.pushtechnology.repackaged.picocontainer.behaviors.Guarding;
import com.pushtechnology.repackaged.picocontainer.behaviors.ImplementationHiding;
import com.pushtechnology.repackaged.picocontainer.behaviors.Locking;
import com.pushtechnology.repackaged.picocontainer.behaviors.PropertyApplying;
import com.pushtechnology.repackaged.picocontainer.behaviors.Synchronizing;
import com.pushtechnology.repackaged.picocontainer.injectors.AdaptingInjection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingBehavior
implements BehaviorFactory,
Serializable {
    public ComponentAdapter createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        ArrayList<BehaviorFactory> list = new ArrayList<BehaviorFactory>();
        ComponentFactory lastFactory = this.makeInjectionFactory();
        this.processSynchronizing(componentProperties, list);
        this.processLocking(componentProperties, list);
        this.processPropertyApplying(componentProperties, list);
        this.processAutomatic(componentProperties, list);
        this.processImplementationHiding(componentProperties, list);
        this.processCaching(componentProperties, componentImplementation, list);
        this.processGuarding(componentProperties, componentImplementation, list);
        for (ComponentFactory componentFactory : list) {
            if (lastFactory != null && componentFactory instanceof BehaviorFactory) {
                ((BehaviorFactory)componentFactory).wrap(lastFactory);
            }
            lastFactory = componentFactory;
        }
        return lastFactory.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
    }

    public ComponentAdapter addComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, ComponentAdapter adapter) {
        ArrayList<BehaviorFactory> list = new ArrayList<BehaviorFactory>();
        this.processSynchronizing(componentProperties, list);
        this.processImplementationHiding(componentProperties, list);
        this.processCaching(componentProperties, adapter.getComponentImplementation(), list);
        this.processGuarding(componentProperties, adapter.getComponentImplementation(), list);
        BehaviorFactory lastFactory = null;
        for (BehaviorFactory componentFactory : list) {
            if (lastFactory != null) {
                componentFactory.wrap(lastFactory);
            }
            lastFactory = componentFactory;
        }
        if (lastFactory == null) {
            return adapter;
        }
        return lastFactory.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter);
    }

    @Override
    public void verify(PicoContainer container) {
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentFactory(this);
    }

    protected AdaptingInjection makeInjectionFactory() {
        return new AdaptingInjection();
    }

    protected void processSynchronizing(Properties componentProperties, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.SYNCHRONIZE)) {
            list.add(new Synchronizing());
        }
    }

    protected void processLocking(Properties componentProperties, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.LOCK)) {
            list.add(new Locking());
        }
    }

    protected void processCaching(Properties componentProperties, Class componentImplementation, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.CACHE) || componentImplementation.getAnnotation(Cache.class) != null) {
            list.add(new Caching());
        }
        AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.NO_CACHE);
    }

    protected void processGuarding(Properties componentProperties, Class componentImplementation, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.arePropertiesPresent(componentProperties, Characteristics.GUARD, false)) {
            list.add(new Guarding());
        }
    }

    protected void processImplementationHiding(Properties componentProperties, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.HIDE_IMPL)) {
            list.add(new ImplementationHiding());
        }
        AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.NO_HIDE_IMPL);
    }

    protected void processPropertyApplying(Properties componentProperties, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.PROPERTY_APPLYING)) {
            list.add(new PropertyApplying());
        }
    }

    protected void processAutomatic(Properties componentProperties, List<BehaviorFactory> list) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent(componentProperties, Characteristics.AUTOMATIC)) {
            list.add(new Automating());
        }
    }

    @Override
    public ComponentFactory wrap(ComponentFactory delegate) {
        throw new UnsupportedOperationException();
    }
}

