/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.v4.services;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.sender.AbstractServiceReference;
import com.pushtechnology.diffusion.command.sender.ReferenceCallback;
import com.pushtechnology.diffusion.command.sender.ServiceWiring;
import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ResponseHandler;
import com.pushtechnology.diffusion.io.serialisation.ReadSerialiser;
import com.pushtechnology.diffusion.io.serialisation.WriteSerialiser;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.message.Sender;
import com.pushtechnology.diffusion.message.ServiceMessage;
import com.pushtechnology.diffusion.timeout.Cancellable;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

@Immutable
public class ServiceReferenceImpl<C, R, P extends Sender>
extends AbstractServiceReference<C, R> {
    private static final Logger LOG = I18nLogger.getLogger(ServiceReferenceImpl.class);
    private final P sender;
    private final ServiceDefinition<C, R> service;
    private final ReadSerialiser<R> responseSerialiser;
    private final ServiceWiring serviceWiring;
    private final WriteSerialiser<C> commandSerialiser;

    public ServiceReferenceImpl(ServiceDefinition<C, R> service, WriteSerialiser<C> commandSerialiser, ReadSerialiser<R> responseSerialiser, ServiceWiring serviceWiring, P sender) {
        this.serviceWiring = serviceWiring;
        this.sender = sender;
        this.service = service;
        this.commandSerialiser = commandSerialiser;
        this.responseSerialiser = responseSerialiser;
    }

    @Override
    public final Cancellable sendCommand(C request, ReferenceCallback<R> callback) {
        LOG.trace("{}.sendCommand({})", (Object)this, (Object)request);
        ConversationId cid = this.send(request, new V4ResponseHandler(callback));
        return () -> this.cancelConversation(cid);
    }

    private CancellationException cancelConversation(ConversationId cid) {
        CancellationException e = new CancellationException("Time out waiting for response to a " + this.service.getName() + " request");
        this.serviceWiring.getConversations().discard(cid, e);
        return e;
    }

    @Override
    public final CompletableFuture<R> sendCommand(C request, UnaryOperator<Throwable> exceptionTranslation) {
        LOG.trace("{}.sendCommand({})", (Object)this, (Object)request);
        V4ResponseHandlerCF result = new V4ResponseHandlerCF(exceptionTranslation);
        ConversationId cid = this.send(request, result);
        result.setConversation(cid);
        return result;
    }

    private ConversationId send(C request, ResponseHandler result) {
        this.onRequest(this.sender);
        return this.serviceWiring.getConversations().newConversation(cid -> this.sendRequest(cid.getId(), request), result);
    }

    private void sendRequest(long cid, C command) {
        ServiceMessage.ServiceRequestMessage message = ServiceMessage.createRequest(this.service.getID(), cid, this.commandSerialiser, command);
        this.sender.send(message);
    }

    protected void onRequest(P peer) {
    }

    protected void onResponse() {
    }

    protected void onError(ErrorReason errorReason, P peer) {
    }

    private void onError(Throwable reason) {
        if (reason instanceof ErrorReasonException) {
            this.onError(((ErrorReasonException)reason).getErrorReason(), this.sender);
        }
    }

    public final String toString() {
        return String.format("ServiceReference <%s> %s", this.service, this.sender);
    }

    private final class V4ResponseHandler
    implements ResponseHandler {
        private final ReferenceCallback<R> callback;

        private V4ResponseHandler(ReferenceCallback<R> callback) {
            this.callback = callback;
        }

        @Override
        public boolean onResponse(ConversationId id, Object input) {
            Object response;
            InputStream in = (InputStream)input;
            try {
                response = ServiceReferenceImpl.this.responseSerialiser.read(in);
            }
            catch (IOException e) {
                LOG.debug("Failed to deserialise response from {}", (Object)ServiceReferenceImpl.this.service, (Object)e);
                this.callback.onFailure(e);
                return true;
            }
            ServiceReferenceImpl.this.onResponse();
            try {
                this.callback.onResponse(response);
            }
            catch (Exception e) {
                LOG.error("REQUEST_CALLBACK_EXCEPTION", (Object)this.callback, (Object)e);
            }
            return true;
        }

        @Override
        public void onDiscard(ConversationId id, Throwable reason) {
            ServiceReferenceImpl.this.onError(reason);
            this.callback.onFailure(reason);
        }
    }

    private final class V4ResponseHandlerCF
    extends WaitProtectedCompletableFuture<R>
    implements ResponseHandler {
        private final UnaryOperator<Throwable> exceptionTranslation;
        private volatile ConversationId conversationId;

        private V4ResponseHandlerCF(UnaryOperator<Throwable> exceptionTranslation) {
            this.exceptionTranslation = exceptionTranslation;
        }

        @Override
        public boolean onResponse(ConversationId cid, Object input) {
            Object response;
            InputStream in = (InputStream)input;
            try {
                response = ServiceReferenceImpl.this.responseSerialiser.read(in);
            }
            catch (IOException e) {
                LOG.debug("Failed to deserialise response from {}", (Object)ServiceReferenceImpl.this.service, (Object)e);
                ServiceReferenceImpl.this.serviceWiring.getConversations().discard(cid, e);
                this.completeExceptionally(e);
                return true;
            }
            ServiceReferenceImpl.this.onResponse();
            this.complete(response);
            return true;
        }

        @Override
        public void onDiscard(ConversationId cid, Throwable reason) {
            ServiceReferenceImpl.this.onError(reason);
            this.completeExceptionally((Throwable)this.exceptionTranslation.apply(reason));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.isDone()) {
                return false;
            }
            this.completeExceptionally(ServiceReferenceImpl.this.cancelConversation(this.conversationId));
            return true;
        }

        void setConversation(ConversationId cid) {
            this.conversationId = cid;
        }
    }
}

