/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.string;

import java.nio.ByteBuffer;

public final class StringUtils {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    private StringUtils() {
    }

    public static void appendHex(StringBuilder sb, byte[] bs, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            byte b = bs[i];
            sb.append(HEX[b >> 4 & 0xF]);
            sb.append(HEX[b & 0xF]);
        }
    }

    public static void appendHex(StringBuilder sb, ByteBuffer bb, int start, int end) {
        for (int i = start; i < end; ++i) {
            byte b = bb.get(i);
            sb.append(HEX[b >> 4 & 0xF]);
            sb.append(HEX[b & 0xF]);
        }
    }

    public static boolean isNullOrEmpty(String value) {
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                if (Character.isWhitespace(value.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }
}

