/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.classloader;

import com.pushtechnology.diffusion.exceptions.DiffusionRuntimeException;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class RegisteredImplementations {
    private RegisteredImplementations() {
    }

    public static List<String> allResourceLines(ClassLoader classLoader, String resourceName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<URL> resources = classLoader == null ? ClassLoader.getSystemResources(resourceName) : classLoader.getResources(resourceName);
        HashSet<String> seenURLs = new HashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String urlString = url.toString();
            if (seenURLs.contains(urlString)) continue;
            seenURLs.add(urlString);
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            InputStream in = conn.getInputStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, CharsetUtils.UTF8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    result.add(line);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return result;
    }

    public static <T> List<Class<? extends T>> loadRegisteredImplementations(String resourceName, Class<T> cls) throws RegistrationException {
        return RegisteredImplementations.loadRegisteredImplementations(resourceName, cls, cls.getClassLoader());
    }

    public static <T> List<Class<? extends T>> loadRegisteredImplementations(String resourceName, Class<T> cls, ClassLoader classLoader) throws RegistrationException {
        List<String> names;
        try {
            names = RegisteredImplementations.allResourceLines(classLoader, resourceName);
        }
        catch (IOException e) {
            throw new RegistrationException("Failed to load implementation", e);
        }
        HashSet<String> seen = new HashSet<String>(names.size());
        ArrayList<Class<T>> result = new ArrayList<Class<T>>(names.size());
        for (String implementationName : names) {
            if (!seen.add(implementationName)) continue;
            try {
                Class<?> implementationClass = Class.forName(implementationName);
                if (cls.isAssignableFrom(implementationClass)) {
                    result.add(implementationClass);
                    continue;
                }
                throw new RegistrationException(implementationName + " does not implement " + cls.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RegistrationException("Could not load '" + implementationName + "'", e);
            }
        }
        return result;
    }

    @Immutable
    public static final class RegistrationException
    extends DiffusionRuntimeException {
        private static final long serialVersionUID = 2374192249254540313L;

        RegistrationException(String message) {
            super(message);
        }

        RegistrationException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

