/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.bytebuffer;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.utils.unsafe.UnsafeAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

@Immutable
final class FreeDirectByteBuffer {
    private static final Logger LOG;
    private static final Consumer<ByteBuffer> FREE;
    private static final Method CLEAN_METHOD;

    private FreeDirectByteBuffer() {
    }

    static void freeDirectBuffer(ByteBuffer buffer) {
        FREE.accept(buffer);
    }

    private static void invokeCleaner(ByteBuffer buffer) {
        try {
            CLEAN_METHOD.invoke((Object)UnsafeAccess.UNSAFE, buffer);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.warn("JDK_UNSUPPORTED_FEATURE", (Object)"Failed to clean DirectByteBuffer", (Object)e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    static {
        Consumer<ByteBuffer> free;
        LOG = I18nLogger.getLogger(FreeDirectByteBuffer.class);
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        Method clean = null;
        try {
            clean = UnsafeAccess.UNSAFE.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
            free = FreeDirectByteBuffer::invokeCleaner;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            LOG.warn("JDK_UNSUPPORTED_FEATURE", (Object)"Failed to find sun.misc.Unsafe.invokeCleaner", (Object)e);
            free = ignored -> {};
        }
        CLEAN_METHOD = clean;
        FREE = free;
        FreeDirectByteBuffer.freeDirectBuffer(direct);
    }
}

