/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils;

import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.java7.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;

@Immutable
public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Set<String> stringToSet(String stringValue) {
        return ImmutableSet.from(PropertyUtils.stringToList(stringValue));
    }

    public static List<String> stringToList(String stringValue) {
        ArrayList<String> list = new ArrayList<String>();
        PropertyUtils.stringToCollection(stringValue, list);
        return list;
    }

    private static void stringToCollection(String stringValue, Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        block0: for (int pos = 0; pos < stringValue.length(); ++pos) {
            char c = stringValue.charAt(pos);
            if (!PropertyUtils.isQuote(c)) continue;
            ++pos;
            sb.setLength(0);
            boolean escaped = false;
            while (pos < stringValue.length()) {
                char vc = stringValue.charAt(pos);
                if (escaped) {
                    sb.append(vc);
                    escaped = false;
                } else if (vc == '\\') {
                    escaped = true;
                } else {
                    if (vc == c) {
                        collection.add(sb.toString());
                        continue block0;
                    }
                    sb.append(vc);
                }
                ++pos;
            }
            throw new IllegalArgumentException("Mis-quoted input");
        }
    }

    public static String setToString(Set<String> values) {
        return Streams.stream(values).map(PropertyUtils::quoteAndEscape).sorted().collect(Collectors.joining(","));
    }

    public static String quoteAndEscape(String string) {
        return "\"" + PropertyUtils.escape(string) + "\"";
    }

    public static String escape(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char ci = string.charAt(i);
            if (!PropertyUtils.isQuote(ci) && ci != '\\') continue;
            StringBuilder sb = new StringBuilder(string.length() + 10);
            sb.append(string, 0, i);
            while (i < string.length()) {
                char cj = string.charAt(i);
                switch (cj) {
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    case '\'': {
                        sb.append("\\'");
                        break;
                    }
                    default: {
                        sb.append(cj);
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        return string;
    }

    public static String unquoteAndUnescape(String text) throws IllegalArgumentException {
        return PropertyUtils.unescape(PropertyUtils.unquote(text));
    }

    public static String unquote(String text) throws IllegalArgumentException {
        if (text.length() < 2 || !PropertyUtils.isQuote(text.charAt(0)) || text.charAt(text.length() - 1) != text.charAt(0)) {
            throw new IllegalArgumentException("Invalid input: " + text);
        }
        return text.substring(1, text.length() - 1);
    }

    public static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    public static String unescape(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            sb.append(c);
            escaped = false;
        }
        if (escaped) {
            throw new IllegalArgumentException("Invalid input: " + s);
        }
        return sb.toString();
    }

    public static String mapToString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean separator = false;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (separator) {
                sb.append(',');
            } else {
                separator = true;
            }
            sb.append(PropertyUtils.quoteAndEscape(entry.getKey())).append(':').append(PropertyUtils.quoteAndEscape(entry.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    public static boolean isFixedSessionProperty(String key) {
        return !key.isEmpty() && key.charAt(0) == '$';
    }
}

