/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils;

import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public enum JVMSupport {
    SINGLETON;

    private static final String VENDOR_PROPERTY = "java.vm.vendor";
    private static final String VENDOR_PROPERTY_DEFAULT = "NONE";
    private static final String VENDOR_IBM = "IBM Corporation";
    private static final String JSSE_IBM = "IBMJSSE2";
    private static final String JSSE_SUN = "SunJSSE";
    private static final String X509_IBM = "IbmX509";
    private static final String X509_SUN = "SunX509";
    private final String jsse;
    private final String x509;

    private JVMSupport() {
        String vendor = ConfigurationUtils.getSystemProperty(VENDOR_PROPERTY, VENDOR_PROPERTY_DEFAULT);
        if (VENDOR_IBM.equals(vendor)) {
            this.jsse = JSSE_IBM;
            this.x509 = X509_IBM;
        } else {
            this.jsse = JSSE_SUN;
            this.x509 = X509_SUN;
        }
    }

    public static KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance(JVMSupport.SINGLETON.x509);
    }

    public static TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        return TrustManagerFactory.getInstance(JVMSupport.SINGLETON.x509, JVMSupport.SINGLETON.jsse);
    }
}

