/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils;

import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.nio.channels.ClosedChannelException;

public final class Exceptions {
    private static final String[] ACCEPTABLE_CLOSE_DESCRIPTIONS = new String[]{"An existing connection was forcibly closed by the remote host", "Connection reset by peer", "Broken pipe", "An established connection was aborted by the software in your host machine", "Connection refused", "Inbound closed before receiving peer's close_notify: possible truncation attack?"};

    private Exceptions() {
    }

    private static <T extends Throwable> T firstInstanceOf(Throwable throwable, Class<T> exceptionClass) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!exceptionClass.isInstance(t)) continue;
            return (T)((Throwable)exceptionClass.cast(t));
        }
        return null;
    }

    public static boolean isAcceptableClose(Throwable throwable) {
        return Exceptions.acceptableCloseDescription(throwable) != null;
    }

    public static String acceptableCloseDescription(Throwable cause) {
        IOException ioCause = Exceptions.firstInstanceOf(cause, IOException.class);
        if (ioCause == null) {
            return null;
        }
        if (ioCause instanceof EOFException) {
            return "EOF";
        }
        if (ioCause instanceof ClosedChannelException) {
            return ioCause.getClass().getName();
        }
        String message = ioCause.getMessage();
        if (message != null) {
            for (String acceptable : ACCEPTABLE_CLOSE_DESCRIPTIONS) {
                if (!message.startsWith(acceptable) && !message.endsWith(acceptable)) continue;
                return message;
            }
        }
        return Exceptions.acceptableCloseDescription(ioCause.getCause());
    }

    public static boolean isBindException(Exception ex) {
        for (Throwable e = ex; e != null; e = e.getCause()) {
            if (!(e instanceof BindException)) continue;
            return true;
        }
        return false;
    }
}

