/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static final int GIGABYTE = 0x40000000;
    private static final int MEGABYTE = 0x100000;
    private static final int KILOBYTE = 1024;

    private ConfigurationUtils() {
    }

    public static long millisNumberConverter(String time) throws IllegalArgumentException {
        char lastChar = time.charAt(time.length() - 1);
        if (Character.isLetter(lastChar)) {
            long num = Long.parseLong(time.substring(0, time.length() - 1));
            char suffix = Character.toLowerCase(lastChar);
            switch (suffix) {
                case 'd': {
                    return num * 24L * 1000L * 60L * 60L;
                }
                case 'h': {
                    return num * 1000L * 60L * 60L;
                }
                case 'm': {
                    return num * 1000L * 60L;
                }
                case 's': {
                    return num * 1000L;
                }
            }
            throw new IllegalArgumentException("Invalid time " + time);
        }
        return Long.parseLong(time);
    }

    public static int byteNumberConverter(String number) {
        long value = ConfigurationUtils.longByteNumberConverter(number);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't represent " + number + " as an int");
        }
        return (int)value;
    }

    public static long longByteNumberConverter(String number) {
        char lastChar = number.charAt(number.length() - 1);
        if (Character.isLetter(lastChar)) {
            long num = Long.parseLong(number.substring(0, number.length() - 1), 10);
            char suffix = Character.toLowerCase(lastChar);
            long result = switch (suffix) {
                case 'm' -> num * 0x100000L;
                case 'k' -> num * 1024L;
                case 'g' -> num * 0x40000000L;
                default -> throw new IllegalArgumentException("Invalid suffix " + number);
            };
            if (result < 0L) {
                throw new IllegalArgumentException("Invalid number out of range " + number);
            }
            return result;
        }
        return Long.parseLong(number, 10);
    }

    public static String getSystemProperty(String property) {
        return ConfigurationUtils.getSystemProperty(property, null);
    }

    public static String getSystemProperty(String property, String defaultValue) {
        String value = System.getProperty(property);
        if (value == null) {
            value = System.getenv(property);
        }
        return value == null ? defaultValue : value;
    }

    public static int getIntegerSystemProperty(String property, int defaultValue) {
        String value = ConfigurationUtils.getSystemProperty(property);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                LOG.warn("System property " + property + " has invalid integer value");
            }
        }
        return defaultValue;
    }

    public static long getLongSystemProperty(String property, long defaultValue) {
        String value = ConfigurationUtils.getSystemProperty(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                LOG.warn("System property " + property + " has invalid long value");
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanSystemProperty(String property) {
        String value = ConfigurationUtils.getSystemProperty(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static double getDoubleSystemProperty(String property, double defaultValue) {
        String value = ConfigurationUtils.getSystemProperty(property);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                LOG.warn("System property " + property + " has invalid double value");
            }
        }
        return defaultValue;
    }

    public static float getFloatSystemProperty(String property, float defaultValue) {
        String value = ConfigurationUtils.getSystemProperty(property);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                LOG.warn("System property " + property + " has invalid float value");
            }
        }
        return defaultValue;
    }
}

