/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.util.concurrent.threads;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocalThread;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public class WaitProtectedCompletableFuture<T>
extends CompletableFuture<T> {
    private static final Logger LOG = I18nLogger.getLogger(WaitProtectedCompletableFuture.class);

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.checkBlockingAllowed();
        return super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkBlockingAllowed();
        return super.get(timeout, unit);
    }

    @Override
    public T join() {
        this.checkBlockingAllowed();
        return super.join();
    }

    @Override
    public <U> WaitProtectedCompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return WaitProtectedCompletableFuture.decorate(super.thenApply((Function)fn));
    }

    public WaitProtectedCompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return WaitProtectedCompletableFuture.decorate(super.thenAccept((Consumer)action));
    }

    @Override
    public WaitProtectedCompletableFuture<Void> thenRun(Runnable action) {
        return WaitProtectedCompletableFuture.decorate(super.thenRun(action));
    }

    @Override
    public <U, V> WaitProtectedCompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return WaitProtectedCompletableFuture.decorate(super.thenCombine((CompletionStage)other, (BiFunction)fn));
    }

    public <U> WaitProtectedCompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return WaitProtectedCompletableFuture.decorate(super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action));
    }

    public WaitProtectedCompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return WaitProtectedCompletableFuture.decorate(super.runAfterBoth((CompletionStage)other, action));
    }

    @Override
    public <U> WaitProtectedCompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return WaitProtectedCompletableFuture.decorate(super.applyToEither((CompletionStage)other, (Function)fn));
    }

    public WaitProtectedCompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return WaitProtectedCompletableFuture.decorate(super.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public WaitProtectedCompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return WaitProtectedCompletableFuture.decorate(super.runAfterEither((CompletionStage)other, action));
    }

    @Override
    public <U> WaitProtectedCompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return WaitProtectedCompletableFuture.decorate(super.thenCompose((Function)fn));
    }

    @Override
    public WaitProtectedCompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return WaitProtectedCompletableFuture.decorate(super.whenComplete((BiConsumer)action));
    }

    @Override
    public <U> WaitProtectedCompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return WaitProtectedCompletableFuture.decorate(super.handle((BiFunction)fn));
    }

    @Override
    public WaitProtectedCompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return WaitProtectedCompletableFuture.decorate(super.exceptionally((Function)fn));
    }

    private void checkBlockingAllowed() {
        BlockingCallFromDiffusionThreadException e;
        Thread thread;
        if (!this.isDone() && (thread = Thread.currentThread()) instanceof FastThreadLocalThread && this.completeExceptionally(e = new BlockingCallFromDiffusionThreadException()) && LOG.isWarnEnabled()) {
            LOG.warn("COMPLETABLE_FUTURE_BLOCKING_DISALLOWED", e);
        }
    }

    private static <U> WaitProtectedCompletableFuture<U> decorate(CompletableFuture<? extends U> delegateResult) {
        WaitProtectedCompletableFuture result = new WaitProtectedCompletableFuture();
        delegateResult.whenComplete((T u, U e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(u);
            }
        });
        return result;
    }

    private static class BlockingCallFromDiffusionThreadException
    extends UnsupportedOperationException {
        BlockingCallFromDiffusionThreadException() {
            super("To prevent potential deadlock, get() and join() methods cannot be called from Diffusion-managed threads");
        }
    }
}

