/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.util.concurrent.threads;

import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocalThread;
import com.pushtechnology.diffusion.util.concurrent.threads.UncaughtExceptionLogger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

public final class ThreadFactoryImpl
implements ThreadFactory {
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_HANDLER = new UncaughtExceptionLogger();
    private final String prefix;
    private final AtomicInteger id = new AtomicInteger();
    private final BiFunction<Runnable, String, Thread> threadConstructor;

    public ThreadFactoryImpl(String name) {
        this(name, FastThreadLocalThread::new);
    }

    public ThreadFactoryImpl(String name, BiFunction<Runnable, String, Thread> threadConstructor) {
        this.threadConstructor = threadConstructor;
        this.prefix = name + " Thread_";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.threadConstructor.apply(runnable, ThreadFactoryImpl.threadGroupPrefix() + this.prefix + this.id.getAndIncrement());
        thread.setUncaughtExceptionHandler(UNCAUGHT_HANDLER);
        thread.setDaemon(true);
        return thread;
    }

    private static String threadGroupPrefix() {
        String name = Thread.currentThread().getThreadGroup().getName();
        return "main".equals(name) ? "" : name + "-";
    }
}

