/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.util.concurrent.threads;

import com.pushtechnology.diffusion.lockfree.utilities.BackOffIdleStrategy;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPoolImpl;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;

public enum HandleInboundQueueFull implements ExecutionPoolImpl.QueueFullHandler
{
    INSTANCE;

    private static final Logger LOG;
    private final BackOffIdleStrategy wait = new BackOffIdleStrategy();

    @Override
    public void handleQueueFull(Runnable task, BlockingQueue<Runnable> queue, Thread thread) {
        if (LOG.isErrorEnabled()) {
            LOG.error("THREADS_INBOUND_QUEUE_FULL", (Object)thread, (Object)queue.size());
        }
        int idleCounter = 0;
        while (!queue.offer(task)) {
            idleCounter = this.wait.idle(idleCounter);
        }
    }

    static {
        LOG = I18nLogger.getLogger(HandleInboundQueueFull.class);
    }
}

