/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.util.concurrent.threads;

import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocalThread;
import java.util.Objects;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FastThreadLocal<T>
extends ThreadLocal<T> {
    private static int nextSlot;
    private final Supplier<? extends T> supplier;
    private final int slot = FastThreadLocal.allocateSlot();

    private static synchronized int allocateSlot() {
        return nextSlot++;
    }

    public FastThreadLocal() {
        this(() -> null);
    }

    public static <T> FastThreadLocal<T> withInitial(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return new FastThreadLocal<Object>(() -> FastThreadLocal.checkNotNull(supplier.get()));
    }

    private FastThreadLocal(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    protected T initialValue() {
        return this.supplier.get();
    }

    @Override
    public T get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            FastThreadLocalThread t = (FastThreadLocalThread)thread;
            Object v = t.computeIfAbsent(this.slot, this.supplier);
            return (T)v;
        }
        return super.get();
    }

    @Override
    public void set(T value) {
        FastThreadLocal.checkNotNull(value);
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            FastThreadLocalThread t = (FastThreadLocalThread)thread;
            t.set(this.slot, value);
        } else {
            super.set(value);
        }
    }

    public T getAndSet(T value) {
        FastThreadLocal.checkNotNull(value);
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            FastThreadLocalThread t = (FastThreadLocalThread)thread;
            Object v = t.getAndSet(this.slot, value);
            return (T)(v == null ? this.supplier.get() : v);
        }
        Object previous = super.get();
        super.set(value);
        return previous;
    }

    private static <T> T checkNotNull(T value) {
        return Objects.requireNonNull(value, "Null values not supported");
    }

    @Override
    public void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).set(this.slot, null);
        } else {
            super.remove();
        }
    }
}

