/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.util.concurrent.scheduled;

import com.pushtechnology.diffusion.util.concurrent.scheduled.Periodic;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import com.pushtechnology.repackaged.picocontainer.Startable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicTaskStarter
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicTaskStarter.class);
    private final CommonThreadPools threadPools;
    private final Collection<? extends Periodic> periodics;

    public PeriodicTaskStarter(CommonThreadPools threadPools, Collection<? extends Periodic> periodics) {
        this.threadPools = threadPools;
        this.periodics = periodics;
    }

    @Override
    public void start() {
        for (Periodic periodic : this.periodics) {
            Pair<Long, Runnable> task = periodic.getPeriodicTask();
            LOG.trace("starting {}", (Object)periodic);
            this.threadPools.getBackgroundThreadPool().scheduleWithFixedDelay(task.getSecond(), 0L, task.getFirst(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
    }
}

