/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.usage.snapshot;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.usage.UsageType;
import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshot;
import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshotSerialiser;
import com.pushtechnology.diffusion.usage.snapshot.UsageSnapshot;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol28-usage-snapshot", valueType=UsageSnapshot.class)
public final class UsageSnapshotSerialiser
extends AbstractSerialiser<UsageSnapshot> {
    private static final EnumConverter<UsageType> TYPE_CONVERTER = new EnumConverter.Builder<UsageType>(UsageType.class).bimap(0, UsageType.USAGE_COLLECTOR).bimap(1, UsageType.USAGE_PROVIDER).bimap(2, UsageType.NONE).build();
    private final SampleSnapshotSerialiser sampleSnapshotSerialiser;

    public UsageSnapshotSerialiser(SampleSnapshotSerialiser sampleSnapshotSerialiser) {
        this.sampleSnapshotSerialiser = sampleSnapshotSerialiser;
    }

    @Override
    public void write(OutputStream out, UsageSnapshot usageSnapshot) throws IOException {
        EncodedDataCodec.writeString(out, usageSnapshot.getLicenceUuid());
        EncodedDataCodec.writeString(out, usageSnapshot.getInstanceIdentifier());
        EncodedDataCodec.writeInt64(out, usageSnapshot.getInstanceStartTime());
        EncodedDataCodec.writeString(out, usageSnapshot.getServerName());
        EncodedDataCodec.writeByte(out, TYPE_CONVERTER.toByte(usageSnapshot.getUsageType()));
        this.sampleSnapshotSerialiser.write(out, usageSnapshot.getSampleSnapshot());
        EncodedDataCodec.writeByte(out, usageSnapshot.getVersion());
    }

    @Override
    protected UsageSnapshot readUnchecked(InputStream in) throws IOException {
        String licenceUuid = EncodedDataCodec.readString(in);
        String instanceIdentifier = EncodedDataCodec.readString(in);
        long instanceStartTime = EncodedDataCodec.readInt64(in);
        String serverName = EncodedDataCodec.readString(in);
        UsageType usageType = TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        SampleSnapshot sampleSnapshot = (SampleSnapshot)this.sampleSnapshotSerialiser.read(in);
        byte version = EncodedDataCodec.readByte(in);
        return new UsageSnapshot(licenceUuid, instanceIdentifier, instanceStartTime, serverName, usageType, sampleSnapshot, version);
    }
}

