/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.usage.snapshot;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshot;
import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshotType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol28-sample-snapshot", valueType=SampleSnapshot.class)
public final class SampleSnapshotSerialiser
extends AbstractSerialiser<SampleSnapshot> {
    private static final EnumConverter<SampleSnapshotType> CONVERTER = new EnumConverter.Builder<SampleSnapshotType>(SampleSnapshotType.class).bimap(0, SampleSnapshotType.SNAPSHOT_START_UP).bimap(1, SampleSnapshotType.SNAPSHOT_PERIODIC).bimap(2, SampleSnapshotType.SNAPSHOT_SHUTDOWN).build();

    @Override
    public void write(OutputStream out, SampleSnapshot sampleSnapshot) throws IOException {
        EncodedDataCodec.writeInt32(out, sampleSnapshot.getSnapshotNumber());
        EncodedDataCodec.writeInt64(out, sampleSnapshot.getSnapshotTime());
        EncodedDataCodec.writeByte(out, CONVERTER.toByte(sampleSnapshot.getSampleSnapshotType()));
        SampleSnapshotSerialiser.writeStringMap(out, sampleSnapshot.getStringDetails());
        SampleSnapshotSerialiser.writeMap(out, EncodedDataCodec::writeString, EncodedDataCodec::writeInt64, sampleSnapshot.getLongDetails());
    }

    @Override
    protected SampleSnapshot readUnchecked(InputStream in) throws IOException {
        int snapshotNumber = EncodedDataCodec.readInt32(in);
        long snapshotTime = EncodedDataCodec.readInt64(in);
        SampleSnapshotType sampleSnapshotType = CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        Map<String, String> stringDetails = SampleSnapshotSerialiser.readStringMap(in);
        Map<String, Long> longDetails = SampleSnapshotSerialiser.readMap(in, EncodedDataCodec::readString, EncodedDataCodec::readInt64);
        return new SampleSnapshot(snapshotNumber, snapshotTime, sampleSnapshotType, stringDetails, longDetails);
    }
}

