/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.usage.snapshot;

import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshotType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class SampleSnapshot {
    private final int snapshotNumber;
    private final long snapshotTime;
    private final SampleSnapshotType sampleSnapshotType;
    private final Map<String, String> stringDetails = new HashMap<String, String>();
    private final Map<String, Long> longDetails = new HashMap<String, Long>();
    private final Map<String, Object> details = new HashMap<String, Object>();

    public SampleSnapshot(int snapshotNumber, long snapshotTime, SampleSnapshotType sampleSnapshotType, Map<String, String> stringDetails, Map<String, Long> longDetails) {
        this.snapshotNumber = snapshotNumber;
        this.snapshotTime = snapshotTime;
        this.sampleSnapshotType = sampleSnapshotType;
        this.stringDetails.putAll(stringDetails);
        this.longDetails.putAll(longDetails);
        this.details.putAll(stringDetails);
        this.details.putAll(longDetails);
    }

    public int getSnapshotNumber() {
        return this.snapshotNumber;
    }

    public long getSnapshotTime() {
        return this.snapshotTime;
    }

    public SampleSnapshotType getSampleSnapshotType() {
        return this.sampleSnapshotType;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public String toString() {
        return "SampleSnapshot{snapshotNumber=" + this.snapshotNumber + ", snapshotTime=" + this.snapshotTime + ", usageSnapshotType=" + String.valueOf((Object)this.sampleSnapshotType) + ", detailsSize=" + this.details.size() + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SampleSnapshot)) {
            return false;
        }
        SampleSnapshot otherSampleSnapshot = (SampleSnapshot)other;
        return this.snapshotNumber == otherSampleSnapshot.snapshotNumber && this.snapshotTime == otherSampleSnapshot.snapshotTime && this.sampleSnapshotType == otherSampleSnapshot.sampleSnapshotType && Objects.equals(this.details, otherSampleSnapshot.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotNumber, this.snapshotTime, this.sampleSnapshotType, this.details});
    }

    Map<String, String> getStringDetails() {
        return this.stringDetails;
    }

    Map<String, Long> getLongDetails() {
        return this.longDetails;
    }
}

