/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.types;

import com.pushtechnology.diffusion.client.types.ErrorReport;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.types.ErrorReportImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="error-report", valueType=ErrorReport.class)
public final class ErrorReportSerialiser
extends AbstractSerialiser<ErrorReport> {
    @Override
    public void write(OutputStream out, ErrorReport value) throws IOException {
        EncodedDataCodec.writeString(out, value.getMessage());
        EncodedDataCodec.writeInt32(out, value.getLine());
        EncodedDataCodec.writeInt32(out, value.getColumn());
    }

    @Override
    protected ErrorReport readUnchecked(InputStream in) throws IOException {
        String message = EncodedDataCodec.readString(in);
        int line = EncodedDataCodec.readInt32(in);
        int column = EncodedDataCodec.readInt32(in);
        return new ErrorReportImpl(message, line, column);
    }
}

