/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.update.update.stream;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamIdSerialiser;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="update-stream-request", valueType=UpdateStreamRequest.class)
public final class UpdateStreamRequestSerialiser
extends AbstractSerialiser<UpdateStreamRequest>
implements TrailingBytesWriteSerialiser<UpdateStreamRequest> {
    private final Serialiser<UpdateStreamId> streamIdSerialiser;

    public UpdateStreamRequestSerialiser(UpdateStreamIdSerialiser streamIdSerialiser) {
        this.streamIdSerialiser = streamIdSerialiser;
    }

    @Override
    protected UpdateStreamRequest readUnchecked(InputStream in) throws IOException {
        UpdateStreamId streamId = (UpdateStreamId)this.streamIdSerialiser.read(in);
        byte[] bytes = EncodedDataCodec.readByteArray(in);
        return new UpdateStreamRequest(streamId, IBytes.toIBytes(bytes));
    }

    @Override
    public void writeHead(OutputStream out, UpdateStreamRequest value) throws IOException {
        this.streamIdSerialiser.write(out, value.getStreamId());
    }

    @Override
    public IBytes getTail(UpdateStreamRequest request) {
        return request.getUpdate();
    }
}

