/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.update.update.stream;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="update-stream-id", valueType=UpdateStreamId.class)
public final class UpdateStreamIdSerialiser
extends AbstractSerialiser<UpdateStreamId> {
    @Override
    protected UpdateStreamId readUnchecked(InputStream in) throws IOException {
        boolean clustered;
        int topicId = EncodedDataCodec.readInt32(in);
        int instanceId = EncodedDataCodec.readInt32(in);
        int serialisedPartitionId = EncodedDataCodec.readInt32(in);
        boolean bl = clustered = serialisedPartitionId != 0;
        if (clustered) {
            int partitionId = serialisedPartitionId - 1;
            int generationId = EncodedDataCodec.readInt32(in);
            return new UpdateStreamId(topicId, instanceId, partitionId, generationId);
        }
        EncodedDataCodec.readInt32(in);
        return new UpdateStreamId(topicId, instanceId);
    }

    @Override
    public void write(OutputStream out, UpdateStreamId streamId) throws IOException {
        EncodedDataCodec.writeInt32(out, streamId.getTopicId());
        EncodedDataCodec.writeInt32(out, streamId.getInstanceId());
        if (streamId.isClustered()) {
            EncodedDataCodec.writeInt32(out, streamId.getPartitionId() + 1);
            EncodedDataCodec.writeInt32(out, streamId.getGenerationId());
        } else {
            EncodedDataCodec.writeInt32(out, 0);
            EncodedDataCodec.writeInt32(out, 0);
        }
    }
}

