/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.update;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.jcip.annotations.Immutable;

@Immutable
public final class UpdateResult {
    public static final UpdateResult SUCCESS = new UpdateResult(null, null);
    private final ErrorReason reason;
    private final String description;

    private UpdateResult(ErrorReason reason, String description) {
        this.reason = reason;
        this.description = description;
    }

    public static UpdateResult fromErrorReason(ErrorReason errorReason, String description) {
        return new UpdateResult(Objects.requireNonNull(errorReason, "errorReason is null"), Objects.requireNonNull(description, "description is null"));
    }

    public boolean ifError(BiConsumer<ErrorReason, String> consumer) {
        if (this.reason != null) {
            consumer.accept(this.reason, this.description);
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.reason == null && this.description == null) {
            return "Update result success";
        }
        return "UpdateResult{reason=" + String.valueOf(this.reason) + ", description='" + this.description + "'}";
    }
}

