/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.java7.Streams;
import com.pushtechnology.diffusion.topics.selectors.AbstractTopicSelector;
import java.util.Collection;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;

@Immutable
class SelectorSet<T extends TopicSelector>
extends AbstractTopicSelector {
    private final Collection<T> selectors;

    SelectorSet(Collection<T> selectors, String remainder, TopicSelector.Type type) {
        this(selectors, Streams.stream(selectors).map(TopicSelector::getPathPrefix).collect(Collectors.toList()).toArray(new String[0]), remainder, type);
    }

    protected SelectorSet(Collection<T> selectors, String[] prefixes, String remainder, TopicSelector.Type type) {
        super(remainder, SelectorSet.extractCommonPathPrefix(prefixes), type);
        this.selectors = selectors;
    }

    public final Collection<T> getComponentSelectors() {
        return this.selectors;
    }

    @Override
    public final boolean selects(String topicPath) {
        for (TopicSelector s : this.selectors) {
            if (!s.selects(topicPath)) continue;
            return true;
        }
        return false;
    }

    private static String extractCommonPathPrefix(String[] prefixes) {
        if (prefixes.length == 0) {
            return "";
        }
        String first = prefixes[0];
        int indexOfFirstDifference = SelectorSet.indexOfFirstDifference(prefixes);
        if (indexOfFirstDifference == first.length()) {
            return first;
        }
        for (int i = indexOfFirstDifference - 1; i > 0; --i) {
            if (first.charAt(i) != '/') continue;
            return first.substring(0, i);
        }
        return "";
    }

    private static int indexOfFirstDifference(String[] prefixes) {
        String first = prefixes[0];
        int firstDifference = first.length();
        for (String next : prefixes) {
            firstDifference = SelectorSet.indexOfFirstDifference(first, next, Math.min(firstDifference, next.length()));
        }
        return firstDifference;
    }

    private static int indexOfFirstDifference(String a, String b, int limit) {
        for (int j = 0; j < limit; ++j) {
            if (a.charAt(j) == b.charAt(j)) continue;
            return j;
        }
        return limit;
    }
}

