/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.topics.selectors.DescendantQualifier;
import com.pushtechnology.diffusion.topics.tree.TopicPathUtilities;
import com.pushtechnology.diffusion.utils.tuple.Pair;
import java.util.BitSet;
import net.jcip.annotations.Immutable;

@Immutable
final class SelectorComponents {
    private static final BitSet META_CHARS = new BitSet();
    private final TopicSelector.Type type;
    private final String base;
    private final String prefix;
    private final int suffixIndex;
    private final String remainder;
    private final DescendantQualifier qualifier;

    static SelectorComponents create(TopicSelector.Type type, String remainder) {
        int suffixIndex;
        String base;
        DescendantQualifier qualifier;
        String prefix;
        if (type == TopicSelector.Type.PATH) {
            prefix = TopicPathUtilities.canonicalisePath(remainder);
            qualifier = DescendantQualifier.MATCH;
            base = remainder;
            suffixIndex = remainder.length();
        } else {
            if (remainder.endsWith("//")) {
                qualifier = DescendantQualifier.MATCH_AND_DESCENDANTS;
                base = TopicPathUtilities.canonicalisePath(remainder.substring(0, remainder.length() - 2));
            } else if (remainder.endsWith("/")) {
                qualifier = DescendantQualifier.DESCENDANTS_OF_MATCH;
                base = TopicPathUtilities.canonicalisePath(remainder.substring(0, remainder.length() - 1));
            } else {
                qualifier = DescendantQualifier.MATCH;
                base = TopicPathUtilities.canonicalisePath(remainder);
            }
            Pair<String, Integer> prefixAndSuffixIndex = SelectorComponents.extractPathPrefixFromRegex(base);
            prefix = prefixAndSuffixIndex.getFirst();
            suffixIndex = prefixAndSuffixIndex.getSecond();
        }
        return new SelectorComponents(type, base, prefix, suffixIndex, remainder, qualifier);
    }

    private SelectorComponents(TopicSelector.Type type, String base, String prefix, int suffixIndex, String remainder, DescendantQualifier qualifier) {
        this.type = type;
        this.base = base;
        this.prefix = prefix;
        this.suffixIndex = suffixIndex;
        this.remainder = remainder;
        this.qualifier = qualifier;
    }

    DescendantQualifier getQualifier() {
        return this.qualifier;
    }

    String getRemainder() {
        return this.remainder;
    }

    String getPrefix() {
        return this.prefix;
    }

    String getSuffix() {
        return this.suffixIndex == 0 ? this.base : this.base.substring(this.suffixIndex + 1);
    }

    String getBase() {
        return this.base;
    }

    TopicSelector.Type getType() {
        return this.type;
    }

    boolean usePathSelector() {
        if (this.type == TopicSelector.Type.PATH) {
            return true;
        }
        if (this.type == TopicSelector.Type.SELECTOR_SET || this.prefix.isEmpty()) {
            return false;
        }
        if (this.base.indexOf(92) == -1) {
            return this.prefix.equals(this.base);
        }
        return this.prefix.matches(this.base);
    }

    static boolean isRegexMetaCharacter(char c) {
        return META_CHARS.get(c);
    }

    static boolean containsRegexMetaCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!SelectorComponents.isRegexMetaCharacter(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static Pair<String, Integer> extractPathPrefixFromRegex(String remainder) {
        int firstSeparator = remainder.length();
        int lastSeparator = 0;
        for (int i = 0; i < remainder.length(); ++i) {
            char c = remainder.charAt(i);
            if (c == '\\') {
                return SelectorComponents.extractPathPrefixFromEscapedRegex(remainder, lastSeparator);
            }
            if (SelectorComponents.isRegexMetaCharacter(c)) {
                return Pair.of(remainder.substring(0, lastSeparator), lastSeparator);
            }
            if (c == '/') {
                firstSeparator = Math.min(firstSeparator, i);
                lastSeparator = i;
                continue;
            }
            firstSeparator = remainder.length();
        }
        return Pair.of(remainder.substring(0, firstSeparator), firstSeparator);
    }

    private static Pair<String, Integer> extractPathPrefixFromEscapedRegex(String remainder, int start) {
        StringBuilder result = new StringBuilder(remainder.length());
        result.append(remainder, 0, start);
        Parser parser = Parser.NORMAL;
        int lastSeparator = start;
        int prefixLength = start;
        for (int i = start; i < remainder.length(); ++i) {
            char c = remainder.charAt(i);
            if (c == '\\' && i < remainder.length() - 1) {
                char next = remainder.charAt(i + 1);
                if (parser == Parser.NORMAL) {
                    ++i;
                    if (next == 'Q') {
                        parser = Parser.QUOTED;
                        continue;
                    }
                    if (SelectorComponents.isAsciiAlpha(next)) {
                        return Pair.of(result.substring(0, prefixLength), lastSeparator);
                    }
                    result.append(next);
                    continue;
                }
                assert (parser == Parser.QUOTED) : parser;
                if (next == 'E') {
                    ++i;
                    parser = Parser.NORMAL;
                    continue;
                }
                result.append(c);
                continue;
            }
            if (c == '/') {
                lastSeparator = i;
                prefixLength = result.length();
            } else if (!parser.isValid(c)) {
                return Pair.of(result.substring(0, prefixLength), lastSeparator);
            }
            result.append(c);
        }
        return Pair.of(result.toString(), lastSeparator);
    }

    private static boolean isAsciiAlpha(char next) {
        return next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z';
    }

    static {
        META_CHARS.set(42);
        META_CHARS.set(46);
        META_CHARS.set(43);
        META_CHARS.set(63);
        META_CHARS.set(94);
        META_CHARS.set(36);
        META_CHARS.set(123);
        META_CHARS.set(125);
        META_CHARS.set(40);
        META_CHARS.set(41);
        META_CHARS.set(91);
        META_CHARS.set(93);
        META_CHARS.set(92);
        META_CHARS.set(124);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Parser {
        NORMAL{

            @Override
            public boolean isValid(char c) {
                return !META_CHARS.get(c);
            }
        }
        ,
        QUOTED{

            @Override
            public boolean isValid(char c) {
                return true;
            }
        };


        abstract boolean isValid(char var1);
    }
}

