/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.topics.tree.TopicPathUtilities;
import net.jcip.annotations.Immutable;

@Immutable
abstract class AbstractTopicSelector
implements TopicSelector {
    private final String remainder;
    private final String prefix;
    private final TopicSelector.Type type;
    private final int hash;

    protected AbstractTopicSelector(String remainder, String prefix, TopicSelector.Type type) {
        this.remainder = remainder;
        this.prefix = prefix;
        this.type = type;
        this.hash = type.hashCode() * 31 + remainder.hashCode();
    }

    @Override
    public final TopicSelector.Type getType() {
        return this.type;
    }

    @Override
    public final String getPathPrefix() {
        return this.prefix;
    }

    @Override
    public final String getExpression() {
        return this.type.getExpressionPrefix() + this.remainder;
    }

    protected final String getRemainder() {
        return this.remainder;
    }

    final void appendExpression(StringBuilder sb) {
        sb.append(this.type.getExpressionPrefix()).append(this.remainder);
    }

    static boolean startsWithPath(String path, String prefix) {
        if (prefix.isEmpty()) {
            return true;
        }
        int prefixLength = prefix.length();
        return (path.length() == prefixLength || path.length() > prefixLength && path.charAt(prefixLength) == '/') && TopicPathUtilities.startsWith(path, prefix);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractTopicSelector other = (AbstractTopicSelector)o;
        return this.hash == other.hashCode() && this.type.equals((Object)other.type) && this.remainder.equals(other.remainder);
    }

    public final int hashCode() {
        return this.hash;
    }

    public final String toString() {
        return String.valueOf((Object)this.type) + ":" + this.remainder;
    }
}

