/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.topics.selectors.AbstractTopicSelector;
import com.pushtechnology.diffusion.topics.selectors.DescendantQualifier;
import com.pushtechnology.diffusion.topics.selectors.SelectorComponents;
import com.pushtechnology.diffusion.topics.tree.TopicPathUtilities;
import net.jcip.annotations.Immutable;

@Immutable
abstract class AbstractNonSetTopicSelector
extends AbstractTopicSelector {
    private final DescendantQualifier descendantQualifier;

    AbstractNonSetTopicSelector(SelectorComponents components) {
        this(components.getQualifier(), components.getRemainder(), components.getPrefix(), components.getType());
    }

    private AbstractNonSetTopicSelector(DescendantQualifier descendantQualifier, String remainder, String prefix, TopicSelector.Type type) {
        super(remainder, prefix, type);
        this.descendantQualifier = descendantQualifier;
    }

    public final DescendantQualifier getDescendantQualifier() {
        return this.descendantQualifier;
    }

    @Override
    public final boolean selects(String path) {
        return this.selects(path, this.getDescendantQualifier());
    }

    public final boolean selects(String path, DescendantQualifier dq) {
        if (path == null) {
            return false;
        }
        String canonical = TopicPathUtilities.canonicalisePath(path);
        return this.sharesPrefixWithPath(canonical) && this.confirmSelects(canonical, dq);
    }

    public final boolean confirmSelects(String path) {
        return this.confirmSelects(path, this.getDescendantQualifier());
    }

    protected abstract boolean confirmSelects(String var1, DescendantQualifier var2);

    public final boolean sharesPrefixWithPath(String path) {
        return AbstractNonSetTopicSelector.startsWithPath(path, this.getPathPrefix());
    }
}

