/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.details;

import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.details.TopicPropertyNormalisers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class TopicSpecificationImpl
implements TopicSpecification {
    public static final String CREATOR = "_CREATOR";
    public static final String VIEW = "_VIEW";
    public static final String ALERT = "_ALERT";
    private final TopicType theType;
    private final Map<String, String> theProperties;

    public TopicSpecificationImpl(TopicType type, Map<String, String> properties) {
        this(TopicSpecificationImpl.unmodifiableProperties(TopicPropertyNormalisers.NORMALISERS.normaliseProperties(type, properties)), type);
    }

    public TopicSpecificationImpl(TopicType type) {
        this(Collections.emptyMap(), type);
    }

    protected TopicSpecificationImpl(Map<String, String> normalisedProperties, TopicType type) {
        this.theProperties = normalisedProperties;
        this.theType = type;
    }

    @Override
    public final TopicType getType() {
        return this.theType;
    }

    @Override
    public final Map<String, String> getProperties() {
        return this.theProperties;
    }

    @Override
    public final TopicSpecification withProperty(String key, String value) {
        String normalisedValue = TopicPropertyNormalisers.NORMALISERS.normaliserFor(this.theType).normaliseValue(TopicPropertyNormalisers.checkKey(key), Objects.requireNonNull(value, "value is null"));
        if (normalisedValue == null) {
            return this.withoutProperties(key);
        }
        HashMap<String, String> newProperties = new HashMap<String, String>(this.theProperties);
        newProperties.put(key, normalisedValue);
        return new TopicSpecificationImpl(Collections.unmodifiableMap(newProperties), this.theType);
    }

    @Override
    public final TopicSpecification withProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : Objects.requireNonNull(properties, "properties is null").entrySet()) {
            String key = TopicPropertyNormalisers.checkKey(entry.getKey());
            Objects.requireNonNull(entry.getValue(), "value of property " + key + " is null");
        }
        HashMap<String, String> newProperties = new HashMap<String, String>(this.theProperties);
        newProperties.putAll(properties);
        return new TopicSpecificationImpl(this.theType, newProperties);
    }

    @Override
    public final TopicSpecification withoutProperties(String ... propertyNames) {
        Map<String, String> properties = this.theProperties;
        for (String p : propertyNames) {
            if (!properties.containsKey(p)) continue;
            HashMap<String, String> newProperties = new HashMap<String, String>(properties);
            for (String propertyName : propertyNames) {
                newProperties.remove(propertyName);
            }
            return new TopicSpecificationImpl(this.theType, newProperties);
        }
        return this;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.theProperties.hashCode();
        result = 31 * result + this.theType.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicSpecification)) {
            return false;
        }
        TopicSpecification other = (TopicSpecification)obj;
        return this.theType == other.getType() && this.theProperties.equals(other.getProperties());
    }

    public final String toString() {
        return "TopicSpecification [Type=" + String.valueOf((Object)this.theType) + ", Properties=" + String.valueOf(this.theProperties) + "]";
    }

    private static Map<String, String> unmodifiableProperties(Map<String, String> newProperties) {
        return newProperties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(newProperties);
    }

    public void serialiseProperties(OutputStream out) throws IOException {
        AbstractSerialiser.writeStringMap(out, this.getProperties());
    }
}

