/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.details;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class TopicProperties {
    public static final TopicProperties NONE = new TopicProperties(Collections.emptyMap());
    private static final Set<String> FILTERED_KEYS = new HashSet<String>();
    private final Map<Key, String> thePropertyMap;

    public TopicProperties(Map<Key, String> properties) {
        this.thePropertyMap = properties;
    }

    public static TopicProperties createFrom(Map<String, String> properties) {
        HashMap<Key, String> propertyMap = new HashMap<Key, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (FILTERED_KEYS.contains(key)) continue;
            propertyMap.put(Key.valueOf(key), entry.getValue());
        }
        return new TopicProperties(propertyMap);
    }

    public Map<String, String> asStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Key, String> entry : this.thePropertyMap.entrySet()) {
            map.put(entry.getKey().name(), entry.getValue());
        }
        return map;
    }

    public Map<Key, String> getPropertyMap() {
        return this.thePropertyMap;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            TopicProperties other = (TopicProperties)obj;
            return this.thePropertyMap.equals(other.thePropertyMap);
        }
        return false;
    }

    public int hashCode() {
        return this.thePropertyMap.hashCode();
    }

    public String toString() {
        return this.thePropertyMap.toString();
    }

    static {
        FILTERED_KEYS.add("TIDY_ON_UNSUBSCRIBE");
        FILTERED_KEYS.add("_VIEW");
        FILTERED_KEYS.add("_ALERT");
    }

    public static enum Key {
        PUBLISH_VALUES_ONLY,
        VALIDATE_VALUES,
        TIME_SERIES_EVENT_VALUE_TYPE,
        TIME_SERIES_RETAINED_RANGE,
        TIME_SERIES_SUBSCRIPTION_RANGE,
        SCHEMA,
        DONT_RETAIN_VALUE,
        PERSISTENT,
        REMOVAL,
        _CREATOR,
        CONFLATION,
        OWNER;

    }
}

