/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.update;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesAppendRequestSerialiser;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesTimestampAppendRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="time-series-timestamp-append-request", valueType=TimeSeriesTimestampAppendRequest.class)
public final class TimeSeriesTimestampAppendRequestSerialiser
extends AbstractSerialiser<TimeSeriesTimestampAppendRequest> {
    private final DataTypes dataTypes;
    private final TimeSeriesAppendRequestSerialiser timeSeriesAppendRequestSerialiser;

    public TimeSeriesTimestampAppendRequestSerialiser(DataTypes dataTypes, TimeSeriesAppendRequestSerialiser timeSeriesAppendRequestSerialiser) {
        this.dataTypes = dataTypes;
        this.timeSeriesAppendRequestSerialiser = timeSeriesAppendRequestSerialiser;
    }

    @Override
    public void write(OutputStream out, TimeSeriesTimestampAppendRequest value) throws IOException {
        this.timeSeriesAppendRequestSerialiser.write(out, value);
        EncodedDataCodec.writeInt64(out, value.getTimestamp());
    }

    @Override
    protected TimeSeriesTimestampAppendRequest readUnchecked(InputStream in) throws IOException {
        String topicPath = EncodedDataCodec.readString(in);
        DataType<?> dataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        long timestamp = EncodedDataCodec.readInt64(in);
        return new TimeSeriesTimestampAppendRequest(topicPath, dataType, request, timestamp);
    }
}

