/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.update;

import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class TimeSeriesAppendRequest
implements Journable {
    private final String topicPath;
    private final DataType<?> dataType;
    private final IBytes value;

    public TimeSeriesAppendRequest(String topicPath, DataType<?> dataType, IBytes value) {
        this.topicPath = topicPath;
        this.dataType = dataType;
        this.value = value;
    }

    public final String getTopicPath() {
        return this.topicPath;
    }

    public final DataType<?> getDataType() {
        return this.dataType;
    }

    public final IBytes getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.topicPath.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeSeriesAppendRequest)) {
            return false;
        }
        TimeSeriesAppendRequest other = (TimeSeriesAppendRequest)o;
        return this.topicPath.equals(other.topicPath) && this.dataType.equals(other.dataType) && this.value.equals(other.value);
    }

    public String toString() {
        return "append(\"" + this.topicPath + "\", " + String.valueOf(this.dataType) + ", " + String.valueOf(this.value) + ")";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(3);
        context.put("path", this.topicPath);
        context.put("type", this.dataType.getTypeName());
        return context;
    }
}

